/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.data.xsd;

import com.bmw.gki.ka.exception.GKIException;
import com.bmw.gki.klib.api.exception.XMLBearbeitungsException;
import com.bmw.gki.klib.api_current.TypeMileage;
import com.bmw.gki.klib.api_current.TypeUnitValue;
import com.bmw.gki.klib.api_current.impl.TypeMileageImpl;
import com.bmw.gki.klib.api_current.impl.TypeUnitValueImpl;
import com.bmw.gki.klib.util.GKIHelper;
import com.bmw.gki.logging.GKILogManager;
import java.math.BigDecimal;
import java.util.Locale;
import org.apache.commons.logging.Log;

public class Mileage {
    private static Log log = GKILogManager.getInstance().getLogger(Mileage.class);
    public static final String CLASS_NAME = "Mileage";
    public static final String UNIT_DISTANCE_KM = "km";
    public static final String UNIT_DISTANCE_MILES = "miles";
    public static final String ATT_UNITS = "units";
    public static final String ATT_UNITS_IN_DISPLAY_FORMAT = "unitsInDisplayFormat";
    public static final String ATT_VALUE_IN_DISPLAY_FORMAT = "valueInDisplayFormat";
    private String value = null;
    private String units = null;

    protected Mileage() {
    }

    public Mileage(String value, String units) throws GKIException {
        this.setValue(value);
        this.setUnits(units);
    }

    public String getUnits() {
        return this.units;
    }

    public String getValue() {
        return this.value;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public TypeMileage createMileageType(Locale locale) throws GKIException {
        TypeMileageImpl element = new TypeMileageImpl();
        try {
            element.setUnits(this.getUnits());
            element.setValue(new Long(this.getValue()));
            element.setUnitsInDisplayFormat(this.getXSDUnitsInDisplayFormat(locale));
            element.setValueInDisplayFormat(GKIHelper.determineNumberFormatter(locale).format(new Integer(this.getValue())));
        }
        catch (Exception e) {
            String message = "Mileage createMileageType XML failure";
            XMLBearbeitungsException be = new XMLBearbeitungsException(message, e);
            log.fatal((Object)("error code: " + be.getErrorCode() + " " + message), (Throwable)e);
            throw be;
        }
        return element;
    }

    public TypeMileage createAverageDistanceTermMileageType(Locale locale) {
        TypeMileageImpl element = new TypeMileageImpl();
        try {
            String unitsInDisplayFormat = null;
            String xsdUnits = this.getUnits();
            unitsInDisplayFormat = xsdUnits.equals(UNIT_DISTANCE_MILES) ? GKIHelper.getTableString("auftragsbasisDialog.auftragsbasisTable.restlaufColumn.miles", locale) + " / " + GKIHelper.getTableString("auftragsbasisDialog.auftragsbasisTable.restlaufColumn.woche", locale) : GKIHelper.getTableString("auftragsbasisDialog.auftragsbasisTable.restlaufColumn.km", locale) + " / " + GKIHelper.getTableString("auftragsbasisDialog.auftragsbasisTable.restlaufColumn.woche", locale);
            element.setUnits(this.getUnits());
            element.setValue(new Long(this.getValue()));
            element.setUnitsInDisplayFormat(unitsInDisplayFormat);
            element.setValueInDisplayFormat(GKIHelper.determineNumberFormatter(locale).format(new Integer(this.getValue())));
        }
        catch (Exception e) {
            String message = "Mileage createAverage Distance XML failure";
            XMLBearbeitungsException be = new XMLBearbeitungsException(message, e);
            log.fatal((Object)("error code: " + be.getErrorCode() + " " + message));
            throw be;
        }
        return element;
    }

    public TypeUnitValue createTypeUnit(Locale locale) throws GKIException {
        TypeUnitValueImpl element = new TypeUnitValueImpl();
        try {
            element.setUnits(this.getUnits());
            element.setValue(new BigDecimal(this.getValue()));
            element.setUnitsInDisplayFormat(this.getXSDUnitsInDisplayFormat(locale));
            element.setValueInDisplayFormat(GKIHelper.determineNumberFormatter(locale).format(new Integer(this.getValue())));
        }
        catch (Exception e) {
            String message = "Mileage createTypeUNit - XML failure";
            XMLBearbeitungsException be = new XMLBearbeitungsException(message, e);
            log.fatal((Object)("error code: " + be.getErrorCode() + " " + message), (Throwable)e);
            throw be;
        }
        return element;
    }

    protected String getXSDUnitsInDisplayFormat(Locale locale) throws GKIException {
        String unitsInDisplayFormat = null;
        String xsdUnits = this.getUnits();
        unitsInDisplayFormat = xsdUnits.equals(UNIT_DISTANCE_MILES) ? GKIHelper.getTableString("auftragsbasisDialog.auftragsbasisTable.restlaufColumn.miles", locale) : (xsdUnits.equals(UNIT_DISTANCE_KM) ? GKIHelper.getTableString("auftragsbasisDialog.auftragsbasisTable.restlaufColumn.km", locale) : GKIHelper.getTableString("auftragsbasisDialog.auftragsbasisTable.restlaufColumn.tage", locale));
        return unitsInDisplayFormat;
    }
}

