/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.data.xsd;

import com.bmw.gki.ka.exception.GKIException;
import com.bmw.gki.klib.api.AuftragsbasisGrunddatenIF;
import com.bmw.gki.klib.api.exception.XMLBearbeitungsException;
import com.bmw.gki.klib.api_current.StateInformationType;
import com.bmw.gki.klib.api_current.TypeUnitValue;
import com.bmw.gki.klib.api_current.impl.TypeUnitValueImpl;
import com.bmw.gki.klib.data.orderbase.SchluesseldatenE65;
import com.bmw.gki.klib.util.GKIHelper;
import com.bmw.gki.logging.GKILogManager;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.commons.logging.Log;

public class MiscAttributes {
    private static Log log = GKILogManager.getInstance().getLogger(MiscAttributes.class);
    public static final String CLASS_NAME = "MiscAttributes";
    public static final String TAG_MISC_ATTRIBUTES = "miscAttributes";
    public static final String TAG_BATTERY_VOLTAGE = "batteryVoltage";
    public static final String TAG_TANK_LEVEL = "tankLevel";
    public static final String TAG_COOLANT_TEMPERATURE = "coolantTemperature";
    public static final String TAG_AIR_TEMPERATURE = "airTemperature";
    public static final String ATT_UNITS = "units";
    public static final String DEFAULT_UNITS_PIECES = "pieces";
    public static final String ATT_UNITS_IN_DISPLAY_FORMAT = "unitsInDisplayFormat";
    public static final String ATT_VALUE_IN_DISPLAY_FORMAT = "valueInDisplayFormat";
    private String batteryVoltage = null;
    private String batteryVoltageUnits = null;
    private String tankLevel = null;
    private String tankLevelUnits = null;
    private String coolantTemperature = null;
    private String coolantTemperatureUnits = null;
    private String airTemperature = null;
    private String airTemperatureUnits = null;

    private MiscAttributes() {
    }

    public String getAirTemperature() {
        return this.airTemperature;
    }

    public String getAirTemperatureUnits() {
        if (this.airTemperatureUnits != null) {
            return this.airTemperatureUnits;
        }
        return DEFAULT_UNITS_PIECES;
    }

    public String getBatteryVoltage() {
        return this.batteryVoltage;
    }

    public String getBatteryVoltageUnits() {
        if (this.batteryVoltageUnits != null) {
            return this.batteryVoltageUnits;
        }
        return DEFAULT_UNITS_PIECES;
    }

    public String getCoolantTemperature() {
        return this.coolantTemperature;
    }

    public String getCoolantTemperatureUnits() {
        if (this.coolantTemperatureUnits != null) {
            return this.coolantTemperatureUnits;
        }
        return DEFAULT_UNITS_PIECES;
    }

    public String getTankLevel() {
        return this.tankLevel;
    }

    public String getTankLevelUnits() {
        if (this.tankLevelUnits != null) {
            return this.tankLevelUnits;
        }
        return DEFAULT_UNITS_PIECES;
    }

    public void setAirTemperature(String airTemperature) {
        this.airTemperature = airTemperature;
    }

    public void setAirTemperatureUnits(String airTemperatureUnits) {
        this.airTemperatureUnits = airTemperatureUnits;
    }

    public void setBatteryVoltage(String batteryVoltage) {
        this.batteryVoltage = batteryVoltage;
    }

    public void setBatteryVoltageUnits(String batteryVoltageUnits) {
        this.batteryVoltageUnits = batteryVoltageUnits;
    }

    public void setCoolantTemperature(String coolantTemperature) {
        this.coolantTemperature = coolantTemperature;
    }

    public void setCoolantTemperatureUnits(String coolantTemperatureUnits) {
        this.coolantTemperatureUnits = coolantTemperatureUnits;
    }

    public void setTankLevel(String tankLevel) {
        this.tankLevel = tankLevel;
    }

    public void setTankLevelUnits(String tankLevelUnits) {
        this.tankLevelUnits = tankLevelUnits;
    }

    public static StateInformationType.MiscAttributes createMiscAttributes(StateInformationType.MiscAttributes element, AuftragsbasisGrunddatenIF ab, Locale locale, boolean isFahrenheit, boolean isUSGallons, boolean isUKGallons) throws GKIException {
        try {
            SchluesseldatenE65 sdE65 = (SchluesseldatenE65)ab.getSchluesseldaten();
            if (sdE65.getBatteriespannung() > 0.0) {
                element.setBatteryVoltage(MiscAttributes.createNodeBatteryVoltage(sdE65, locale));
            }
            element.setTankLevel(MiscAttributes.createTankLevel(sdE65, locale, isUSGallons, isUKGallons));
            element.setCoolantTemperature(MiscAttributes.createCoolantTemperature(sdE65, locale, isFahrenheit));
            element.setAirTemperature(MiscAttributes.createAirTemperature(sdE65, locale, isFahrenheit));
        }
        catch (GKIException e) {
            throw e;
        }
        catch (Exception e) {
            String message = "MiscAttributes createMiscAttributes XML failure";
            XMLBearbeitungsException be = new XMLBearbeitungsException(message, e);
            log.fatal((Object)("error code: " + be.getErrorCode() + " " + message), (Throwable)e);
            throw be;
        }
        return element;
    }

    public static TypeUnitValue createNodeBatteryVoltage(SchluesseldatenE65 sdE65, Locale locale) {
        TypeUnitValueImpl unit = new TypeUnitValueImpl();
        NumberFormat numberFormat = GKIHelper.determineNumberFormatter(locale);
        try {
            double batteriespannung = sdE65.getBatteriespannung();
            unit.setUnits("V");
            unit.setValue(new BigDecimal(batteriespannung));
            String unitsInDisplayFormat = GKIHelper.getTableString("auftragsbasisDialog.mobilerService.batteriespannungeinheit.label", locale);
            unit.setUnitsInDisplayFormat(unitsInDisplayFormat);
            String valueInDisplayFormat = numberFormat.format(batteriespannung);
            unit.setValueInDisplayFormat(valueInDisplayFormat);
        }
        catch (Exception e) {
            String message = "MiscAttributes createNodeBatteryVoltage XML failure";
            XMLBearbeitungsException be = new XMLBearbeitungsException(message, e);
            log.fatal((Object)("error code: " + be.getErrorCode() + " " + message), (Throwable)e);
            throw be;
        }
        return unit;
    }

    public static TypeUnitValue createTankLevel(SchluesseldatenE65 sdE65, Locale locale, boolean isUSGallons, boolean isUKGallons) {
        TypeUnitValueImpl unit = new TypeUnitValueImpl();
        try {
            double tankinhalt = sdE65.getTankinhalt(isUSGallons, isUKGallons);
            String units = null;
            units = isUSGallons ? "US.liq.gal" : (isUKGallons ? "Imp.gal" : "l");
            unit.setUnits(units);
            unit.setValue(new BigDecimal(tankinhalt));
            String unitsInDisplayFormat = null;
            unitsInDisplayFormat = isUSGallons ? GKIHelper.getTableString("auftragsbasisDialog.mobilerService.tankinhalteinheit.USgallons", locale) : (isUKGallons ? GKIHelper.getTableString("auftragsbasisDialog.mobilerService.tankinhalteinheit.UKgallons", locale) : GKIHelper.getTableString("auftragsbasisDialog.mobilerService.tankinhalteinheit.liter", locale));
            unit.setUnitsInDisplayFormat(unitsInDisplayFormat);
            NumberFormat numberFormatter = GKIHelper.determineNumberFormatter(locale);
            String valueInDisplayFormat = numberFormatter.format(tankinhalt);
            unit.setValueInDisplayFormat(valueInDisplayFormat);
        }
        catch (Exception e) {
            String message = "MisAttributes createTankLevel - XML failure";
            XMLBearbeitungsException be = new XMLBearbeitungsException(message, e);
            log.fatal((Object)("error code: " + be.getErrorCode() + " " + message), (Throwable)e);
            throw be;
        }
        return unit;
    }

    public static TypeUnitValue createCoolantTemperature(SchluesseldatenE65 sdE65, Locale locale, boolean isFahrenheit) throws GKIException {
        TypeUnitValueImpl unit = new TypeUnitValueImpl();
        try {
            double kuehlmitteltemperatur = sdE65.getKuehlmitteltemperatur(isFahrenheit);
            String units = null;
            units = isFahrenheit ? "\u00b0F" : "\u00b0C";
            unit.setUnits(units);
            unit.setValue(new BigDecimal(kuehlmitteltemperatur));
            String unitsInDisplayFormat = null;
            unitsInDisplayFormat = isFahrenheit ? GKIHelper.getTableString("auftragsbasisDialog.mobilerService.kuehlmitteltemperatureinheit.fahrenheit", locale) : GKIHelper.getTableString("auftragsbasisDialog.mobilerService.kuehlmitteltemperatureinheit.celsius", locale);
            unit.setUnitsInDisplayFormat(unitsInDisplayFormat);
            String valueInDisplayFormat = GKIHelper.determineNumberFormatter(locale).format(kuehlmitteltemperatur);
            unit.setValueInDisplayFormat(valueInDisplayFormat);
        }
        catch (Exception e) {
            String message = "Misc Attributes createCoolantTemperature  XML failure";
            XMLBearbeitungsException be = new XMLBearbeitungsException(message, e);
            log.fatal((Object)("error code: " + be.getErrorCode() + " " + message));
            throw be;
        }
        return unit;
    }

    public static TypeUnitValue createAirTemperature(SchluesseldatenE65 sdE65, Locale locale, boolean isFahrenheit) throws GKIException {
        TypeUnitValueImpl unit = new TypeUnitValueImpl();
        try {
            int keyvariante = sdE65.getSchluesselVariante().getSchluesselVariante();
            Double aTemp = sdE65.getAussentemperatur(isFahrenheit);
            if (aTemp == null || sdE65.getHerkunft() == 'S' && keyvariante < 8) {
                return null;
            }
            double aussentemperatur = aTemp;
            String units = null;
            units = isFahrenheit ? "\u00b0F" : "\u00b0C";
            unit.setUnits(units);
            unit.setValue(new BigDecimal(aussentemperatur));
            String unitsInDisplayFormat = null;
            unitsInDisplayFormat = isFahrenheit ? GKIHelper.getTableString("auftragsbasisDialog.mobilerService.temperatureinheit.fahrenheit", locale) : GKIHelper.getTableString("auftragsbasisDialog.mobilerService.temperatureinheit.celsius", locale);
            unit.setUnitsInDisplayFormat(unitsInDisplayFormat);
            String valueInDisplayFormat = GKIHelper.determineNumberFormatter(locale).format(aussentemperatur);
            unit.setValueInDisplayFormat(valueInDisplayFormat);
        }
        catch (Exception e) {
            String message = "MiscAttributes createAirTemperature XML failure";
            XMLBearbeitungsException be = new XMLBearbeitungsException(message, e);
            log.fatal((Object)("error code: " + be.getErrorCode() + " " + message));
            throw be;
        }
        return unit;
    }
}

