/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.data.xsd;

import com.bmw.gki.ka.exception.GKIException;
import com.bmw.gki.klib.api.exception.XMLBearbeitungsException;
import com.bmw.gki.klib.api_current.OrderBaseType;
import com.bmw.gki.klib.api_current.impl.OrderBaseTypeImpl;
import com.bmw.gki.klib.config.GKISettings;
import com.bmw.gki.klib.data.orderbase.SchluesseldatenVorE65;
import com.bmw.gki.klib.data.xsd.Mileage;
import com.bmw.gki.klib.util.Utilities;
import com.bmw.gki.logging.GKILogManager;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceIntervalDisplay {
    private static Log log = GKILogManager.getInstance().getLogger(ServiceIntervalDisplay.class);
    public static final String CLASS_NAME = "ServiceIntervalDisplay";
    public static final String TAG_SERVICE_INTERVAL_DISPLAY = "serviceIntervalDisplay";
    public static final String ATT_CODE = "code";
    public static final String TAG_REMAINING_DISTANCE = "remainingDistance";
    public static final String TAG_SID_3LIGHTS = "sid3Lights";
    public static final String COLOUR_GREEN = "green";
    public static final String COLOUR_YELLOW = "yellow";
    public static final String COLOUR_RED = "red";
    public static final String COLOUR_NONE = "none";
    private String code = null;
    private String remainingDistance = null;
    private String remainingDistanceUnits = null;
    private String sid3LightsGreen = null;
    private String sid3LightsYellow = null;
    private String sid3LightsRed = null;

    public ServiceIntervalDisplay(Node node) throws GKIException {
        this.read(node);
    }

    public String getCode() {
        return this.code;
    }

    public String getRemainingDistanceUnits() {
        return this.remainingDistanceUnits;
    }

    public String getRemainingDistance() {
        return this.remainingDistance;
    }

    public String getSid3LightsGreen() {
        return this.sid3LightsGreen;
    }

    public String getSid3LightsRed() {
        return this.sid3LightsRed;
    }

    public String getSid3LightsYellow() {
        return this.sid3LightsYellow;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setRemainingDistance(String remainingDistance) {
        this.remainingDistance = remainingDistance;
    }

    public void setRemainingDistanceUnits(String remainingDistanceUnits) {
        this.remainingDistanceUnits = remainingDistanceUnits;
    }

    public void setSid3LightsGreen(String sid3LightsGreen) {
        this.sid3LightsGreen = sid3LightsGreen;
    }

    public void setSid3LightsRed(String sid3LightsRed) {
        this.sid3LightsRed = sid3LightsRed;
    }

    public void setSid3LightsYellow(String sid3LightsYellow) {
        this.sid3LightsYellow = sid3LightsYellow;
    }

    private void read(Node node) throws GKIException {
        try {
            if (node.getAttributes().getNamedItem(ATT_CODE) != null) {
                this.setCode(node.getAttributes().getNamedItem(ATT_CODE).getNodeValue());
            }
            Node tmpNode = null;
            String name = null;
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                tmpNode = children.item(i);
                name = Utilities.getLocalName(tmpNode.getNodeName());
                if (name.equals(TAG_REMAINING_DISTANCE)) {
                    if (tmpNode.getAttributes().getNamedItem("units") != null) {
                        this.setRemainingDistanceUnits(tmpNode.getAttributes().getNamedItem("units").getNodeValue());
                    }
                    if (tmpNode.getFirstChild() == null || tmpNode.getFirstChild().getNodeType() != 3) continue;
                    this.setRemainingDistance(tmpNode.getFirstChild().getNodeValue());
                    continue;
                }
                if (!name.equals(TAG_SID_3LIGHTS)) continue;
                if (tmpNode.getAttributes().getNamedItem(COLOUR_GREEN) != null) {
                    this.setSid3LightsGreen(tmpNode.getAttributes().getNamedItem(COLOUR_GREEN).getNodeValue());
                }
                if (tmpNode.getAttributes().getNamedItem(COLOUR_YELLOW) != null) {
                    this.setSid3LightsYellow(tmpNode.getAttributes().getNamedItem(COLOUR_YELLOW).getNodeValue());
                }
                if (tmpNode.getAttributes().getNamedItem(COLOUR_RED) == null) continue;
                this.setSid3LightsRed(tmpNode.getAttributes().getNamedItem(COLOUR_RED).getNodeValue());
            }
        }
        catch (Exception e) {
            String message = "ServiceIntervalDisplay read Node - XML failure";
            XMLBearbeitungsException be = new XMLBearbeitungsException(message, e);
            log.fatal((Object)("error code: " + be.getErrorCode() + " " + message), (Throwable)e);
            throw be;
        }
    }

    public static OrderBaseType.ServiceInformation.ServiceIntervalDisplay createServiceIntervalDisplay(SchluesseldatenVorE65 sd, GKISettings usersettings, Locale locale) {
        OrderBaseTypeImpl.ServiceInformationImpl.ServiceIntervalDisplayImpl element = new OrderBaseTypeImpl.ServiceInformationImpl.ServiceIntervalDisplayImpl();
        try {
            element.setCode(ServiceIntervalDisplay.erzeugeCodeFuerFaelligeServiceArt(sd));
            element.setSiaVersion(sd.getSiaStand());
            if (sd.getSiaStand() == 4 && sd.getRestweg(usersettings.isMiles()) != null) {
                String restWeg = String.valueOf(sd.getRestweg(usersettings.isMiles()));
                String remainingDistanceUnit = usersettings.isMiles() ? "miles" : "km";
                Mileage mileage = new Mileage(restWeg, remainingDistanceUnit);
                element.setRemainingDistance(mileage.createTypeUnit(locale));
            }
            if (sd.getSiaStand() == 3) {
                OrderBaseTypeImpl.ServiceInformationImpl.ServiceIntervalDisplayImpl.Sid3LightsImpl lights = new OrderBaseTypeImpl.ServiceInformationImpl.ServiceIntervalDisplayImpl.Sid3LightsImpl();
                if (sd.getCountGreen() >= 0) {
                    // empty if block
                }
                lights.setGreen((short)sd.getCountGreen());
                if (sd.isRedSet()) {
                    lights.setRed((short)(sd.isRedSet() ? 1 : 0));
                }
                if (sd.isYellowSet()) {
                    lights.setYellow((short)(sd.isYellowSet() ? 1 : 0));
                }
                element.setSid3Lights(lights);
            }
        }
        catch (Exception e) {
            String message = "ServciceIntervalDisplay createServiceINtervalDisplay - XML failure";
            XMLBearbeitungsException be = new XMLBearbeitungsException(message, e);
            log.fatal((Object)("error code: " + be.getErrorCode() + " " + message), (Throwable)e);
            throw be;
        }
        return element;
    }

    private static String erzeugeCodeFuerFaelligeServiceArt(SchluesseldatenVorE65 sd) {
        if (sd.isOelserviceSet()) {
            if (sd.isZeitinspektionSet()) {
                return "03";
            }
            return "01";
        }
        if (sd.isInspektionSet()) {
            if (sd.isZeitinspektionSet()) {
                return "04";
            }
            return "02";
        }
        if (sd.isZeitinspektionSet()) {
            return "05";
        }
        return "00";
    }
}

