/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.data.xsd;

import com.bmw.gki.ka.exception.GKIException;
import com.bmw.gki.klib.api.AuftragsbasisGrunddatenIF;
import com.bmw.gki.klib.api.exception.XMLBearbeitungsException;
import com.bmw.gki.klib.api_current.StateInformationType;
import com.bmw.gki.klib.api_current.impl.StateInformationTypeImpl;
import com.bmw.gki.klib.api_current.impl.TypeMileageImpl;
import com.bmw.gki.klib.config.GKISettings;
import com.bmw.gki.klib.data.orderbase.SchluesseldatenE65;
import com.bmw.gki.klib.data.xsd.MiscAttributes;
import com.bmw.gki.klib.util.GKIHelper;
import com.bmw.gki.logging.GKILogManager;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.commons.logging.Log;

public class StateInformation {
    private static Log log = GKILogManager.getInstance().getLogger(StateInformation.class);
    public static final String CLASS_NAME = "StateInformation";
    public static final String TAG_STATE_INFORMATION = "stateInformation";
    public static final String TAG_TOTAL_DISTANCE = "totalDistance";
    public static final String TAG_FAULT_INFORMATION = "faultInformation";
    public static final String TAG_LAST_ODOMETER_READING = "lastOdometerReading";
    public static final String ATT_INDICATOR = "indicator";
    private String totalDistance = null;
    private String totalDistanceUnits = null;
    private String faultInformation = null;
    private Boolean faultInformationIndicator = null;
    private MiscAttributes miscAttributes = null;

    private StateInformation() {
    }

    public String getFaultInformation() {
        return this.faultInformation;
    }

    public Boolean getFaultInformationIndicator() {
        return this.faultInformationIndicator;
    }

    public MiscAttributes getMiscAttributes() {
        return this.miscAttributes;
    }

    public String getTotalDistance() {
        return this.totalDistance;
    }

    public String getTotalDistanceUnits() {
        return this.totalDistanceUnits;
    }

    public void setFaultInformation(String faultInformation) {
        this.faultInformation = faultInformation;
    }

    public void setFaultInformationIndicator(Boolean faultInformationIndicator) {
        this.faultInformationIndicator = faultInformationIndicator;
    }

    public void setMiscAttributes(MiscAttributes miscAttributes) {
        this.miscAttributes = miscAttributes;
    }

    public void setTotalDistance(String totalDistance) {
        this.totalDistance = totalDistance;
    }

    public void setTotalDistanceUnits(String totalDistanceUnits) {
        this.totalDistanceUnits = totalDistanceUnits;
    }

    public static StateInformationType writeXMLNode(StateInformationType element, AuftragsbasisGrunddatenIF ab, GKISettings usersettings) throws GKIException {
        try {
            Double doubleValue = ab.getSchluesseldaten().getKmMeilenStand(usersettings);
            Integer value = new Integer(doubleValue.intValue());
            if (value != null) {
                String einheitWegstrecke = !usersettings.isMiles() ? "km" : "miles";
                TypeMileageImpl mileageType = new TypeMileageImpl();
                mileageType.setValue(value.longValue());
                mileageType.setUnits(einheitWegstrecke);
                NumberFormat numberFormat = NumberFormat.getInstance(usersettings.getLocale());
                String unitsInDisplayFormat = StateInformation.getXSDUnitsInDisplayFormat(usersettings.getLocale(), usersettings.isMiles());
                if (unitsInDisplayFormat != null) {
                    mileageType.setUnitsInDisplayFormat(unitsInDisplayFormat);
                }
                String valueInDisplayFormat = numberFormat.format(new Float(value.floatValue()));
                mileageType.setValueInDisplayFormat(valueInDisplayFormat);
                element.setTotalDistance(mileageType);
            }
            if (ab.getSchluesseldaten().isE65upward()) {
                SchluesseldatenE65 sdE65 = (SchluesseldatenE65)ab.getSchluesseldaten();
                Double aTemp = sdE65.getAussentemperatur(usersettings.isFahrenheit());
                if (sdE65.getBatteriespannung() > 0.0 || sdE65.getTankinhalt(usersettings.isGallonsUS(), usersettings.isGallonsUK()) >= 0.0 || aTemp != null && aTemp >= 0.0 || sdE65.getKuehlmitteltemperatur(usersettings.isFahrenheit()) >= 0.0) {
                    element.setMiscAttributes(MiscAttributes.createMiscAttributes(new StateInformationTypeImpl.MiscAttributesImpl(), ab, usersettings.getLocale(), usersettings.isFahrenheit(), usersettings.isGallonsUS(), usersettings.isGallonsUK()));
                }
            }
        }
        catch (GKIException e) {
            throw e;
        }
        catch (Exception e) {
            log.fatal((Object)("writeXMLNode:Exception(" + e.getLocalizedMessage() + ")"), (Throwable)e);
            throw new XMLBearbeitungsException("StateInformation.writeXMLNode:Unerwartete Exception:", e);
        }
        return element;
    }

    private static String getXSDUnitsInDisplayFormat(Locale locale, boolean isMiles) throws GKIException {
        String unitsInDisplayFormat = null;
        unitsInDisplayFormat = isMiles ? GKIHelper.getTableString("auftragsbasisDialog.auftragsbasisTable.restlaufColumn.miles", locale) : GKIHelper.getTableString("auftragsbasisDialog.auftragsbasisTable.restlaufColumn.km", locale);
        return unitsInDisplayFormat;
    }
}

