/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.data.xsd;

import com.bmw.gki.ka.exception.GKIException;
import com.bmw.gki.klib.api.AuftragsbasisGrunddatenIF;
import com.bmw.gki.klib.api.exception.XMLBearbeitungsException;
import com.bmw.gki.klib.api_current.OrderBaseType;
import com.bmw.gki.klib.api_current.impl.OrderBaseTypeImpl;
import com.bmw.gki.klib.api_current.impl.TypeUnitValueImpl;
import com.bmw.gki.klib.config.GKISettings;
import com.bmw.gki.klib.data.apiparams.KeyDataHelper;
import com.bmw.gki.klib.data.orderbase.BOSHeaderDaten;
import com.bmw.gki.klib.data.orderbase.SchluesseldatenE65;
import com.bmw.gki.klib.data.xsd.CbsList;
import com.bmw.gki.klib.data.xsd.Dates;
import com.bmw.gki.klib.data.xsd.Mileage;
import com.bmw.gki.klib.util.GKIHelper;
import com.bmw.gki.klib.util.Utilities;
import com.bmw.gki.logging.GKILogManager;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.logging.Log;

public class TimeLine {
    private static Log log = GKILogManager.getInstance().getLogger(TimeLine.class);
    public static final String CLASS_NAME = "TimeLine";
    public static final String TAG_TIME_LINE = "timeLine";
    public static final String TAG_AVERAGE_DISTANCE = "averageDistance";
    public static final String TAG_NEXT_SERVICE_DATE = "nextServiceDate";
    public static final String TAG_NEXT_SERVICE_DISTANCE = "nextServiceDistance";
    private static final String UNITS_CODE_CBS_HUAU = "Months";
    private static final String UNITS_CODE_CBS_YELLOW = "Weeks";
    private static final String YELLOW_SERVICE_TIME = "weeks";

    private TimeLine() {
    }

    public static OrderBaseType.ServiceInformation.TimeLine createTimeline(AuftragsbasisGrunddatenIF ab, TimeZone timeZone, GKISettings usersettings, Locale locale) throws GKIException {
        OrderBaseTypeImpl.ServiceInformationImpl.TimeLineImpl element = new OrderBaseTypeImpl.ServiceInformationImpl.TimeLineImpl();
        try {
            int yellowServiceTime;
            Integer lowWeg;
            BOSHeaderDaten bosHeader;
            int shortTimeDrivingPerformance;
            String unitsKmMeilen = null;
            unitsKmMeilen = usersettings.isMiles() ? "miles" : "km";
            element.setDates(Dates.createDates(ab, timeZone, usersettings, locale));
            if (ab.getBosAwPositions() != null && ab.getBosAwPositions().size() > 0) {
                element.setCbsList(CbsList.createCbsList(ab, usersettings));
            }
            if ((shortTimeDrivingPerformance = (bosHeader = ((SchluesseldatenE65)ab.getSchluesseldaten()).getBOSDaten()).getShortTimeDrivingPerformance()) > 0) {
                if (usersettings.isMiles()) {
                    shortTimeDrivingPerformance = new Double(Utilities.convertToMiles(shortTimeDrivingPerformance)).intValue();
                }
                Mileage mileage = new Mileage(String.valueOf(shortTimeDrivingPerformance), unitsKmMeilen);
                element.setAverageDistance(mileage.createAverageDistanceTermMileageType(locale));
            }
            int longTimeDrivingPerformance = bosHeader.getFahrleistungLangzeitWert();
            if (usersettings.isMiles()) {
                longTimeDrivingPerformance = new Double(Utilities.convertToMiles(longTimeDrivingPerformance)).intValue();
            }
            Mileage longTermMileage = new Mileage(String.valueOf(longTimeDrivingPerformance), unitsKmMeilen);
            element.setAverageDistanceLongTerm(longTermMileage.createAverageDistanceTermMileageType(locale));
            Date lowZeit = (Date)ab.getBOSAWPositionLowestRestwegValue(2, usersettings.isMiles())[1];
            if (lowZeit != null) {
                element.setNextServiceDate(KeyDataHelper.retrieveXMLGregorianCalendar(lowZeit, timeZone));
            }
            if ((lowWeg = (Integer)ab.getBOSAWPositionLowestRestwegValue(1, usersettings.isMiles())[1]) != null) {
                Mileage mileage = new Mileage(lowWeg.toString(), unitsKmMeilen);
                element.setNextServiceDistance(mileage.createMileageType(locale));
            }
            TypeUnitValueImpl typeUnitCodeCbsHUAU = new TypeUnitValueImpl();
            typeUnitCodeCbsHUAU.setUnits(UNITS_CODE_CBS_HUAU);
            typeUnitCodeCbsHUAU.setUnitsInDisplayFormat(GKIHelper.getTableString("dynamischerZeitstrahlDialog.zeitTable.restlaufColumn.headerValue", locale));
            typeUnitCodeCbsHUAU.setValueInDisplayFormat("" + bosHeader.getCodeCBSHUAU().intValue());
            typeUnitCodeCbsHUAU.setValue(bosHeader.getCodeCBSHUAU());
            element.setCodeCBSHUAU(typeUnitCodeCbsHUAU);
            TypeUnitValueImpl typeUnitCodeCbsYellow = new TypeUnitValueImpl();
            typeUnitCodeCbsYellow.setUnits(UNITS_CODE_CBS_YELLOW);
            typeUnitCodeCbsYellow.setUnitsInDisplayFormat(GKIHelper.getTableString("auftragsbasisDialog.auftragsbasisTable.restlaufColumn.wochen", locale));
            typeUnitCodeCbsYellow.setValueInDisplayFormat("" + bosHeader.getCodeCBSYellow().intValue());
            typeUnitCodeCbsYellow.setValue(bosHeader.getCodeCBSYellow());
            element.setCodeCBSYellow(typeUnitCodeCbsYellow);
            OrderBaseTypeImpl.ServiceInformationImpl.TimeLineImpl.DisplayUnitImpl displayUnitType = new OrderBaseTypeImpl.ServiceInformationImpl.TimeLineImpl.DisplayUnitImpl();
            int value = bosHeader.getDisplayUnit();
            displayUnitType.setCode("" + value);
            String localeToXSDLanguage = Utilities.getLocaleToXSDLanguage(locale);
            displayUnitType.setLanguage(localeToXSDLanguage);
            displayUnitType.setValue(GKIHelper.getTableString("cbs.header.displayunit." + value, locale));
            element.setDisplayUnit(displayUnitType);
            int statusTeleservice = bosHeader.getStatusTeleservice();
            OrderBaseTypeImpl.ServiceInformationImpl.TimeLineImpl.StatusTeleserviceImpl teleservice = new OrderBaseTypeImpl.ServiceInformationImpl.TimeLineImpl.StatusTeleserviceImpl();
            teleservice.setCode("" + statusTeleservice);
            teleservice.setLanguage(localeToXSDLanguage);
            teleservice.setValue(GKIHelper.getTableString("cbs.header.teleservicedata." + statusTeleservice, locale));
            element.setStatusTeleservice(teleservice);
            long yellowServiceDistance = bosHeader.getYellowServiceDistance();
            if (yellowServiceDistance > 0L) {
                String einheitWegstrecke = !usersettings.isMiles() ? "km" : "miles";
                String unitsInDisplayFormat = TimeLine.getXSDUnitsInDisplayFormat(usersettings.getLocale(), usersettings.isMiles());
                if (usersettings.isMiles()) {
                    yellowServiceDistance = Math.round(Utilities.convertToMiles(yellowServiceDistance));
                }
                TypeUnitValueImpl typeUnitCodeYellowServiceDistance = new TypeUnitValueImpl();
                typeUnitCodeYellowServiceDistance.setUnits(einheitWegstrecke);
                if (unitsInDisplayFormat != null) {
                    typeUnitCodeYellowServiceDistance.setUnitsInDisplayFormat(unitsInDisplayFormat);
                }
                typeUnitCodeYellowServiceDistance.setValueInDisplayFormat("" + yellowServiceDistance);
                typeUnitCodeYellowServiceDistance.setValue(new BigDecimal(yellowServiceDistance));
                element.setYellowServiceDistance(typeUnitCodeYellowServiceDistance);
            }
            if ((yellowServiceTime = bosHeader.getYellowServiceTime()) > 0) {
                TypeUnitValueImpl typeUnitCodeYellowServiceTime = new TypeUnitValueImpl();
                typeUnitCodeYellowServiceTime.setUnits(YELLOW_SERVICE_TIME);
                typeUnitCodeYellowServiceTime.setUnitsInDisplayFormat(GKIHelper.getTableString("cbs.header.yellowServiceTime", locale));
                typeUnitCodeYellowServiceTime.setValueInDisplayFormat("" + yellowServiceTime);
                typeUnitCodeYellowServiceTime.setValue(new BigDecimal(yellowServiceTime));
                element.setYellowServiceTime(typeUnitCodeYellowServiceTime);
            }
            element.setCbsCount(bosHeader.getCbsCount());
            element.setCbsVariant(bosHeader.getCbsVariant() + 1);
        }
        catch (GKIException e) {
            throw e;
        }
        catch (Exception e) {
            String message = "TimeLine createTimeline - XML failure";
            XMLBearbeitungsException be = new XMLBearbeitungsException(message, e);
            log.fatal((Object)("error code: " + be.getErrorCode() + " " + message), (Throwable)e);
            throw be;
        }
        return element;
    }

    private static String getXSDUnitsInDisplayFormat(Locale locale, boolean isMiles) throws GKIException {
        String unitsInDisplayFormat = null;
        unitsInDisplayFormat = isMiles ? GKIHelper.getTableString("auftragsbasisDialog.auftragsbasisTable.restlaufColumn.miles", locale) : GKIHelper.getTableString("auftragsbasisDialog.auftragsbasisTable.restlaufColumn.km", locale);
        return unitsInDisplayFormat;
    }
}

