/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.data.xsd;

import com.bmw.gki.ka.exception.GKIException;
import com.bmw.gki.klib.api.AuftragsbasisGrunddatenIF;
import com.bmw.gki.klib.api.exception.GKIWarning;
import com.bmw.gki.klib.api.exception.VehicleFutureUpdateWarning;
import com.bmw.gki.klib.api.exception.VehicleTimeWarning;
import com.bmw.gki.klib.api.exception.XMLBearbeitungsException;
import com.bmw.gki.klib.api_current.OrderBaseType;
import com.bmw.gki.klib.api_current.OriginCodeType;
import com.bmw.gki.klib.api_current.impl.OrderBaseTypeImpl;
import com.bmw.gki.klib.data.apiparams.KeyDataHelper;
import com.bmw.gki.klib.data.apitransformation.TypeErrorAdapter;
import com.bmw.gki.klib.util.GKIHelper;
import com.bmw.gki.klib.util.Utilities;
import com.bmw.gki.logging.GKILogManager;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.logging.Log;

public class VehicleKey {
    private static Log log = GKILogManager.getInstance().getLogger(VehicleKey.class);
    public static final String CLASS_NAME = "VehicleKey";
    public static final String TAG_VEHICLE_KEY = "vehicleKey";
    public static final String ATT_VARIANT = "variant";
    public static final String TAG_ORIGIN_CODE = "originCode";
    public static final String TAG_READIN_DATE = "readInDate";
    public static final String TAG_WRITE_DATE = "writeDate";
    public static final char ORIGIN_CODE_SERVICE_CALL = 'S';
    public static final char ORIGIN_CODE_KEYREADER = 'K';
    private String variant = null;
    private String originCode = null;
    private String readInDate = null;
    private String writeDate = null;

    private VehicleKey() {
    }

    public String getOriginCode() {
        return this.originCode;
    }

    public String getReadInDate() {
        return this.readInDate;
    }

    public Date getReadInDateAsDate() {
        return Utilities.getXSDDateTimeStringToDate(this.getReadInDate());
    }

    public String getVariant() {
        return this.variant;
    }

    public String getWriteDate() {
        return this.writeDate;
    }

    public Date getWriteDateAsDate() {
        return Utilities.getXSDDateTimeStringToDate(this.getWriteDate());
    }

    public void setOriginCode(String originCode) {
        this.originCode = originCode;
    }

    public void setReadInDate(String readInDate) {
        this.readInDate = readInDate;
    }

    public void setVariant(String variant) {
        this.variant = variant;
    }

    public void setWriteDate(String writeDate) {
        this.writeDate = writeDate;
    }

    public void setWriteDateAsDate(Date writeDate) {
        this.setWriteDate(Utilities.getDateToXSDDateTime(writeDate));
    }

    public static OrderBaseType.VehicleKey createXMLNode(OrderBaseType.VehicleKey element, AuftragsbasisGrunddatenIF ab, TimeZone timeZone, List<TypeErrorAdapter> warnings, Locale locale) throws GKIException {
        try {
            int writeMode;
            if (ab.getSchluesseldaten().isLargeKey()) {
                if (ab.getSchluesseldaten().getData().getKeyBaseData().getKeyNumber() != 15) {
                    element.setKeyNumber(ab.getSchluesseldaten().getData().getKeyBaseData().getKeyNumber());
                }
                element.setKeyProfil(ab.getSchluesseldaten().getData().getKeyBaseData().getKeyProfil());
            }
            if (ab.getSchluesseldaten().getSchluesselVariante() != null) {
                element.setSubVariant(new Integer(ab.getSchluesseldaten().getSchluesselVariante().getSubvariante()).toString());
                element.setVariant(new Integer(ab.getSchluesseldaten().getSchluesselVariante().getSchluesselVariante()).toString());
            }
            OriginCodeType orgCodeType = OriginCodeType.fromValue(Character.toString(ab.getSchluesseldaten().getHerkunft()));
            element.setOriginCode(orgCodeType);
            if (ab.getSchluesseldaten() != null && ab.getSchluesseldaten().getEinleseDatum() != null) {
                element.setReadInDate(KeyDataHelper.retrieveXMLGregorianCalendarTime(ab.getSchluesseldaten().getEinleseDatum(), timeZone));
            } else {
                element.setReadInDate(null);
            }
            if (log.isDebugEnabled() && element.getReadInDate() != null) {
                log.debug((Object)("read in date is: " + GKIHelper.getFormattedDateAsString(element.getReadInDate().toGregorianCalendar().getTime())));
            }
            Date dLastUpdate = ab.getSchluesseldaten().getLetzteAktualisierung();
            Calendar calendarFuture = GregorianCalendar.getInstance(timeZone);
            calendarFuture.setTime(ab.getSchluesseldaten().getEinleseDatum());
            calendarFuture.add(5, 3);
            if (dLastUpdate != null) {
                GKIWarning te;
                Calendar calendarUpdate = GregorianCalendar.getInstance(timeZone);
                calendarUpdate.setTime(dLastUpdate);
                if (!ab.getSchluesseldaten().isUhrzeitLetzteAktualisierungGueltig()) {
                    te = new VehicleTimeWarning();
                    log.info((Object)("code: " + ((VehicleTimeWarning)te).getErrorCode() + " key data: write date not valid"));
                    warnings.add(new TypeErrorAdapter(te));
                } else if (calendarFuture.before(calendarUpdate)) {
                    te = new VehicleFutureUpdateWarning();
                    te.addParam(Utilities.getDateString(dLastUpdate, locale));
                    log.info((Object)("code: " + ((VehicleFutureUpdateWarning)te).getErrorCode() + " key data: write date is in future"));
                    warnings.add(new TypeErrorAdapter(te));
                }
                if (ab.getSchluesseldaten() != null && ab.getSchluesseldaten().getLetzteAktualisierung() != null) {
                    element.setWriteDate(KeyDataHelper.retrieveXMLGregorianCalendarTime(ab.getSchluesseldaten().getLetzteAktualisierung(), timeZone));
                } else {
                    element.setWriteDate(null);
                }
            }
            if (ab.getSchluesseldaten().getData().getKeyBaseData().isSetWriteMode() && ((writeMode = ab.getSchluesseldaten().getData().getKeyBaseData().getWriteMode().intValue()) <= 5 || writeMode == 255)) {
                OrderBaseTypeImpl.VehicleKeyImpl.WriteModeImpl writeModeType = new OrderBaseTypeImpl.VehicleKeyImpl.WriteModeImpl();
                String code = "" + writeMode;
                writeModeType.setCode(code);
                writeModeType.setLanguage(Utilities.getLocaleToXSDLanguage(locale));
                writeModeType.setShortName(GKIHelper.getTableString("vehicleKey.writemode.shortname." + code, locale));
                writeModeType.setValue(GKIHelper.getTableString("vehicleKey.writemode.value." + code, locale));
                element.setWriteMode(writeModeType);
            }
        }
        catch (Exception e) {
            String message = "VehicleKey createXMLNode - XML failure";
            XMLBearbeitungsException be = new XMLBearbeitungsException(message, e);
            log.fatal((Object)("error code: " + be.getErrorCode() + " " + message), (Throwable)e);
            throw be;
        }
        return element;
    }
}

