/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.external.cache;

import com.bmw.gki.ka.exception.GKIException;
import com.bmw.gki.ka.util.PreProdHolder;
import com.bmw.gki.ka.util.PreProdLogEntry;
import com.bmw.gki.ka.util.PreProdLogMessages;
import com.bmw.gki.klib.api.exception.KSDPropertyFormatException;
import com.bmw.gki.klib.api.exception.KeineArbeitswerteException;
import com.bmw.gki.klib.api.exception.NotFoundException;
import com.bmw.gki.klib.api.exception.SettingsException;
import com.bmw.gki.klib.data.ksd.cbs.BOSAWNummer;
import com.bmw.gki.klib.data.ksd.cbs.BOSNummer;
import com.bmw.gki.klib.data.ksd.cbs.BOSValue;
import com.bmw.gki.klib.external.cache.BOSNummerReader;
import com.bmw.gki.klib.external.cache.KSDReaderIF;
import com.bmw.gki.klib.util.Utilities;
import com.bmw.gki.logging.GKILogManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;

public class BOSAWNummerReader
implements KSDReaderIF {
    private static Log log = GKILogManager.getInstance().getLogger(BOSAWNummerReader.class);
    private static ArrayList<BOSAWNummer> bosAWNummern = new ArrayList();
    public static final String FILE = "/flat2.properties";
    public static final String FILE_OLD = "/flat.properties";

    public void einlesenTabelle() {
    }

    public static boolean exists(String leittyp, int baustand) {
        for (BOSAWNummer nummer : bosAWNummern) {
            String bosAWLeittyp = nummer.getLeittyp().trim();
            if (!bosAWLeittyp.equals(leittyp)) continue;
            int bosAWBaustandAnfang = nummer.getBaustandAnfang();
            int bosAWBaustandEnde = nummer.getBaustandEnde();
            if (bosAWBaustandEnde == 0 && bosAWBaustandAnfang <= baustand) {
                return true;
            }
            if (bosAWBaustandAnfang > baustand || bosAWBaustandEnde <= baustand) continue;
            return true;
        }
        return false;
    }

    public static void einlesenTabelle(String path) throws KSDPropertyFormatException, SettingsException {
        BOSAWNummerReader.checkPath(path);
        File file = new File(path, FILE);
        String filePath = file.getAbsolutePath();
        boolean isOldVersion = false;
        BufferedReader reader = null;
        try {
            FileReader fileReader;
            try {
                fileReader = new FileReader(file);
            }
            catch (FileNotFoundException fnf) {
                StringBuffer toLog = new StringBuffer();
                toLog.append("BOSAWNumberReader file not found ");
                toLog.append(filePath);
                file = new File(path, FILE_OLD);
                filePath = file.getAbsolutePath();
                toLog.append(" try old Version ");
                toLog.append(filePath);
                log.info((Object)toLog);
                fileReader = new FileReader(file);
                isOldVersion = true;
            }
            reader = new LineNumberReader(new BufferedReader(fileReader), 40000);
            while (reader.ready()) {
                String line = ((LineNumberReader)reader).readLine();
                int lineNr = ((LineNumberReader)reader).getLineNumber();
                BOSAWNummerReader.processLine(line, lineNr, filePath, isOldVersion);
            }
        }
        catch (FileNotFoundException ioe) {
            throw new com.bmw.gki.klib.api.exception.IOException("BOSAWNumberReader file not found", ioe, new String[]{filePath});
        }
        catch (IOException ioe) {
            throw new com.bmw.gki.klib.api.exception.IOException("BOSAWNumberReader IO Exception", ioe, new String[]{filePath});
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private static void processLine(String line, int lineNr, String path, boolean isOldVersion) throws KSDPropertyFormatException {
        if (Utilities.isCommentLine(line)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("linenr:" + lineNr + ", content[" + line + "]"));
        }
        int baustandAnfang = 0;
        int baustandEnde = 0;
        int letzterBaustand = 0;
        int equal = line.indexOf(61);
        String key = line.substring(0, equal);
        String data = line.substring(equal + 1, line.length());
        StringTokenizer tokenizer = new StringTokenizer(key, ";");
        BOSAWNummerReader.checkKeyTokens(tokenizer, path, lineNr);
        String leittyp = BOSValue.testAndGetString(tokenizer.nextToken(), 4, 4, path, lineNr);
        int id = BOSValue.testAndGetInt(tokenizer.nextToken(), 1, 5, path, lineNr);
        BOSNummer bosNummer = BOSAWNummerReader.getBosNummer(id);
        tokenizer = new StringTokenizer(data, ";");
        BOSAWNummerReader.checkDataTokens(tokenizer, path, lineNr, isOldVersion);
        while (tokenizer.hasMoreElements()) {
            baustandEnde = baustandAnfang;
            baustandAnfang = BOSValue.testAndGetBaustand(tokenizer.nextToken(), path, lineNr);
            BOSAWNummerReader.checkTemporalSequence(baustandAnfang, letzterBaustand, path, lineNr);
            String awNummerHaupt1 = tokenizer.nextToken().trim();
            String awWertHaupt1 = tokenizer.nextToken().trim();
            String awNummerVerbund1 = tokenizer.nextToken().trim();
            String awWertVerbund1 = tokenizer.nextToken().trim();
            String ssiAwNummerHaupt1 = isOldVersion ? awNummerHaupt1 : tokenizer.nextToken().trim();
            String ssiAwWertHaupt1 = isOldVersion ? awWertHaupt1 : tokenizer.nextToken().trim();
            String ssiAwNummerVerbund1 = isOldVersion ? awNummerVerbund1 : tokenizer.nextToken().trim();
            String ssiAwWertVerbund1 = isOldVersion ? awWertVerbund1 : tokenizer.nextToken().trim();
            BOSValue.testAndGetString(awNummerHaupt1, 1, 7, path, lineNr);
            BOSValue.testAndGetInt(awWertHaupt1, 1, 3, path, lineNr);
            BOSValue.testAndGetString(awNummerVerbund1, 1, 7, path, lineNr);
            BOSValue.testAndGetInt(awWertVerbund1, 1, 3, path, lineNr);
            BOSValue.testAndGetString(ssiAwNummerHaupt1, 1, 7, path, lineNr);
            BOSValue.testAndGetInt(ssiAwWertHaupt1, 1, 3, path, lineNr);
            BOSValue.testAndGetString(ssiAwNummerVerbund1, 1, 7, path, lineNr);
            BOSValue.testAndGetInt(ssiAwWertVerbund1, 1, 3, path, lineNr);
            bosAWNummern.add(new BOSAWNummer(leittyp, bosNummer, baustandAnfang, baustandEnde, String.valueOf(awNummerHaupt1), String.valueOf(awWertHaupt1), String.valueOf(awNummerVerbund1), String.valueOf(awWertVerbund1), String.valueOf(ssiAwNummerHaupt1), String.valueOf(ssiAwWertHaupt1), String.valueOf(ssiAwNummerVerbund1), String.valueOf(ssiAwWertVerbund1)));
            letzterBaustand = baustandAnfang;
        }
    }

    private static void checkTemporalSequence(int baustandAnfang, int letzterBaustand, String path, int lineNr) throws KSDPropertyFormatException {
        if (letzterBaustand != 0 && baustandAnfang > letzterBaustand) {
            if (PreProdHolder.getIsPreProd()) {
                String message = PreProdLogMessages.getParameterString("CODE_READING_REF_FILES_NOT_VALID", new Object[]{path, "" + lineNr, " Baustand: invalid temporal sequence"});
                PreProdHolder.addLogEntry(new PreProdLogEntry("ERROR", "CODE_READING_REF_FILES_NOT_VALID", message));
            }
            throw new KSDPropertyFormatException("invalid temporal sequence", new String[]{path, "" + lineNr});
        }
    }

    private static void checkDataTokens(StringTokenizer tokenizer, String path, int lineNr, boolean isOldVersion) throws KSDPropertyFormatException {
        if (tokenizer.countTokens() % (isOldVersion ? 5 : 9) != 0) {
            if (PreProdHolder.getIsPreProd()) {
                String message = PreProdLogMessages.getParameterString("CODE_READING_REF_FILES_NOT_VALID", new Object[]{path, "" + lineNr, "token count"});
                PreProdHolder.addLogEntry(new PreProdLogEntry("ERROR", "CODE_READING_REF_FILES_NOT_VALID", message));
            }
            throw new KSDPropertyFormatException("Token count", new String[]{"9", "" + tokenizer.countTokens(), path, "" + lineNr});
        }
    }

    private static BOSNummer getBosNummer(int id) throws KSDPropertyFormatException {
        try {
            return BOSNummerReader.find(id);
        }
        catch (NumberFormatException e) {
            String message = "BOS AW NummernReader id not a number: " + id;
            KSDPropertyFormatException pex = new KSDPropertyFormatException(message);
            log.info((Object)message);
            throw pex;
        }
        catch (GKIException e) {
            String message = "BOS AW NummernReader id: " + id + " not found";
            KSDPropertyFormatException pex = new KSDPropertyFormatException(message);
            log.info((Object)message);
            throw pex;
        }
    }

    private static void checkKeyTokens(StringTokenizer tokenizer, String path, int lineNr) throws KSDPropertyFormatException {
        if (tokenizer.countTokens() != 2) {
            String message;
            if (PreProdHolder.getIsPreProd()) {
                message = PreProdLogMessages.getParameterString("CODE_READING_REF_FILES_NOT_VALID", new Object[]{path, "" + lineNr, "token count"});
                PreProdHolder.addLogEntry(new PreProdLogEntry("ERROR", "CODE_READING_REF_FILES_NOT_VALID", message));
            }
            message = "BOS AW NummernReader token count != 2";
            KSDPropertyFormatException pex = new KSDPropertyFormatException(message);
            log.info((Object)message);
            throw pex;
        }
    }

    private static void checkPath(String path) throws SettingsException {
        if (path == null || path.length() == 0) {
            String message = "mandatory field path (GKI Settings) is not set: " + path;
            SettingsException ke = new SettingsException(message);
            log.info((Object)("exception code: " + ke.getErrorCode() + " " + message));
            throw ke;
        }
    }

    public static BOSAWNummer find(String leittyp, BOSNummer bosNummer, int baustand) throws GKIException {
        for (BOSAWNummer testNummer : bosAWNummern) {
            if (!testNummer.isValid(leittyp, bosNummer, baustand)) continue;
            return testNummer;
        }
        if (PreProdHolder.getIsPreProd()) {
            String id = "";
            if (bosNummer != null) {
                id = bosNummer.getIdString();
            }
            String message = PreProdLogMessages.getParameterString("CODE_BOS_AW_NR_NOT_FOUND", new Object[]{id, leittyp});
            PreProdHolder.addLogEntry(new PreProdLogEntry("INFO", "CODE_BOS_AW_NR_NOT_FOUND", message));
        }
        String message = "AW Position for the cbsId: " + (bosNummer != null ? bosNummer.getBosNr() : -1) + ", the leadtype: " + leittyp + " and the baustand: " + baustand + " doesn't exist";
        KeineArbeitswerteException kawException = new KeineArbeitswerteException(message);
        throw kawException;
    }

    public static BOSAWNummer find(String leittyp, String aw, int baustand) throws GKIException {
        for (BOSAWNummer testNummer : bosAWNummern) {
            if (!testNummer.getLeittyp().equals(leittyp) || !testNummer.isValidBaustand(baustand) || !testNummer.getAwNrHaupt().equals(aw) && !testNummer.getAwNrVerbund().equals(aw)) continue;
            return testNummer;
        }
        throw new NotFoundException("Bosawnummer not found", new String[]{aw, leittyp, "" + baustand});
    }

    public static void reset() {
        bosAWNummern = new ArrayList();
    }
}

