/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.external.cache;

import com.bmw.gki.ka.exception.GKIException;
import com.bmw.gki.ka.util.PreProdHolder;
import com.bmw.gki.ka.util.PreProdLogEntry;
import com.bmw.gki.ka.util.PreProdLogMessages;
import com.bmw.gki.klib.api.exception.KSDPropertyFormatException;
import com.bmw.gki.klib.api.exception.NotFoundException;
import com.bmw.gki.klib.api.exception.SettingsException;
import com.bmw.gki.klib.data.ksd.cbs.BOSNummer;
import com.bmw.gki.klib.data.ksd.cbs.BOSValue;
import com.bmw.gki.klib.data.ksd.cbs.BOSVorziehwert;
import com.bmw.gki.klib.external.cache.BOSNummerReader;
import com.bmw.gki.klib.external.cache.KSDReaderIF;
import com.bmw.gki.klib.util.Utilities;
import com.bmw.gki.logging.GKILogManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.logging.Log;

public class BOSVorziehwertReader
implements KSDReaderIF {
    private static Log log = GKILogManager.getInstance().getLogger(BOSVorziehwertReader.class);
    private static Hashtable<String, Vector<BOSVorziehwert>> bosVorziehwerte = new Hashtable();
    private static final String FILENAME = "_rec.properties";

    public static void einlesenTabelle(String path, String[] regionCodes) throws KSDPropertyFormatException, SettingsException {
        if (path == null || path.length() == 0) {
            String message = "BOSVorziehwertReader mandatory field region  not set: " + path;
            SettingsException ke = new SettingsException(message);
            log.info((Object)("exception code: " + ke.getErrorCode() + " " + message));
            throw ke;
        }
        File dir = new File(path);
        log.info((Object)"reading BOSVorziehwerte into cache.");
        for (int i = 0; i < regionCodes.length; ++i) {
            KSDPropertyFormatException kfe;
            String region = regionCodes[i];
            if (region == null || region.length() == 0) {
                String message = "BOSVorziehwertReader mandatory field region  not set: " + path;
                SettingsException ke = new SettingsException(message);
                log.info((Object)("exception code: " + ke.getErrorCode() + " " + message));
                throw ke;
            }
            Vector<BOSVorziehwert> bosVorziehwerteListe = null;
            if (bosVorziehwerte != null && bosVorziehwerte.get(region) != null) {
                bosVorziehwerteListe = bosVorziehwerte.get(region);
            } else {
                bosVorziehwerteListe = new Vector();
                bosVorziehwerte.put(region, bosVorziehwerteListe);
            }
            File file = new File(dir, region + FILENAME);
            String filePath = file.getAbsolutePath();
            if (PreProdHolder.getIsPreProd() && !file.exists()) continue;
            BufferedReader reader = null;
            try {
                reader = new LineNumberReader(new BufferedReader(new FileReader(file)));
                while (reader.ready()) {
                    String einheit;
                    String line = ((LineNumberReader)reader).readLine();
                    int lineNr = ((LineNumberReader)reader).getLineNumber();
                    if (Utilities.isCommentLine(line)) continue;
                    StringTokenizer tokenizer = new StringTokenizer(line, "=");
                    if (tokenizer.countTokens() != 2) {
                        String message;
                        if (PreProdHolder.getIsPreProd()) {
                            message = PreProdLogMessages.getParameterString("CODE_READING_REF_FILES_NOT_VALID", new Object[]{filePath, "" + lineNr, "Baustand: Invalid temporal sequence"});
                            PreProdHolder.addLogEntry(new PreProdLogEntry("ERROR", "CODE_READING_REF_FILES_NOT_VALID", message));
                        }
                        message = "BOS VorziehwertReader token count != 2";
                        KSDPropertyFormatException pex = new KSDPropertyFormatException(message);
                        log.info((Object)message);
                        throw pex;
                    }
                    String key = tokenizer.nextToken().trim();
                    String data = tokenizer.nextToken().trim();
                    int id = BOSValue.testAndGetInt(key, 1, 5, filePath, lineNr);
                    BOSNummer bosNr = null;
                    try {
                        bosNr = BOSNummerReader.find(id);
                    }
                    catch (GKIException e) {
                        log.info((Object)e.getMessage());
                    }
                    tokenizer = new StringTokenizer(data, ";");
                    if (tokenizer.countTokens() != 2) {
                        if (PreProdHolder.getIsPreProd()) {
                            String message = PreProdLogMessages.getParameterString("CODE_READING_REF_FILES_NOT_VALID", new Object[]{filePath, "" + lineNr, "Baustand: Invalid temporal sequence"});
                            PreProdHolder.addLogEntry(new PreProdLogEntry("ERROR", "CODE_READING_REF_FILES_NOT_VALID", message));
                        }
                        throw new KSDPropertyFormatException("Token count", new String[]{"2", "" + tokenizer.countTokens(), filePath, "" + lineNr});
                    }
                    int wert = BOSValue.testAndGetInt(tokenizer.nextToken(), 1, 19, filePath, lineNr);
                    BOSVorziehwert vorziehWert = new BOSVorziehwert(bosNr, wert, einheit = "" + BOSValue.testAndGetChar(tokenizer.nextToken(), "kw", filePath, lineNr));
                    BOSVorziehwert existWert = BOSVorziehwertReader.containsBosNr(bosVorziehwerteListe, vorziehWert);
                    if (existWert != null) {
                        bosVorziehwerteListe.remove(existWert);
                    }
                    bosVorziehwerteListe.addElement(vorziehWert);
                }
                continue;
            }
            catch (FileNotFoundException ex) {
                String message = "BosVorziehwertReader File not found path: " + path;
                kfe = new KSDPropertyFormatException(message, ex);
                log.info((Object)("exception code: " + kfe.getErrorCode() + " message: " + message));
                throw kfe;
            }
            catch (IOException ex) {
                String message = "BosVorziehwertReader IO Exception path: " + path;
                kfe = new KSDPropertyFormatException(message, ex);
                log.info((Object)("exception code: " + kfe.getErrorCode() + " message: " + message));
                throw kfe;
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    private static BOSVorziehwert containsBosNr(Vector<BOSVorziehwert> liste, BOSVorziehwert wert) {
        for (BOSVorziehwert element : liste) {
            if (element == null || element.getBosNr() != wert.getBosNr()) continue;
            return element;
        }
        return null;
    }

    public static void update(String path, String[] regionCodes) throws GKIException {
        bosVorziehwerte.clear();
        BOSVorziehwertReader.einlesenTabelle(path, regionCodes);
    }

    public static BOSVorziehwert find(String region, BOSNummer bosNr) throws GKIException {
        Vector<BOSVorziehwert> bosVorziehwerteListe = bosVorziehwerte.get(region);
        if (bosVorziehwerteListe != null) {
            for (BOSVorziehwert vorziehwert : bosVorziehwerteListe) {
                if (!bosNr.equals(vorziehwert.getBosNr())) continue;
                return vorziehwert;
            }
        }
        NotFoundException nfe = new NotFoundException("BOS Vorziehwert not found. Id:" + bosNr.getBosNr() + " " + region);
        throw nfe;
    }

    public static void reset() {
        bosVorziehwerte = new Hashtable();
    }
}

