/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.external.cache;

import com.bmw.gki.klib.api.exception.KSDAccessException;
import com.bmw.gki.klib.api.exception.KSDPropertyFormatException;
import com.bmw.gki.klib.data.ksd.battery.BatteryData;
import com.bmw.gki.klib.data.ksd.battery.Interval;
import com.bmw.gki.klib.data.ksd.battery.Rule;
import com.bmw.gki.klib.external.cache.KSDReaderIF;
import com.bmw.gki.klib.util.CSVReader;
import com.bmw.gki.logging.GKILogManager;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;

public class BatteryReader
implements KSDReaderIF {
    private static final int VALUE_RADIX = 16;
    private static final String LT = "<";
    private static final String GT = ">";
    private static final String EQ = "=";
    private static final String GE = ">=";
    private static final String LE = "<=";
    private static final Log LOG = GKILogManager.getInstance().getLogger(BatteryReader.class);
    private static BatteryReader instance;
    private static final String BATTERY_CSV = "/battery.csv";
    private static final String ACTION_BUNDLE = "battery_actions";
    private Hashtable<Locale, ResourceBundle> actions;
    private Rule[] rules;

    public static BatteryReader getInstance() {
        if (instance == null) {
            instance = new BatteryReader();
        }
        return instance;
    }

    public void readInTable(String ksdPath, Locale[] supported) throws KSDAccessException {
        this.readInBatteryActions(ksdPath, ACTION_BUNDLE, supported);
        this.readInRules(ksdPath + BATTERY_CSV);
    }

    private void readInBatteryActions(String path, String resource, Locale[] supported) throws KSDAccessException {
        this.actions = new Hashtable();
        ClassLoader propertyLoader = this.getClassLoader(path);
        if (resource.endsWith(".properties")) {
            resource = StringUtils.substringBeforeLast((String)resource, (String)".properties");
        }
        for (int i = 0; i < supported.length; ++i) {
            ResourceBundle bundle = ResourceBundle.getBundle(resource, supported[i], propertyLoader);
            this.actions.put(supported[i], bundle);
        }
    }

    private ClassLoader getClassLoader(String path) throws KSDAccessException {
        URLClassLoader loader = null;
        try {
            ArrayList<URL> urls = new ArrayList<URL>();
            File file = new File(path);
            if (!file.exists()) {
                String message = "Battery reader invalid path: " + path;
                KSDAccessException ex = new KSDAccessException(message);
                LOG.info((Object)message);
                throw ex;
            }
            urls.add(file.toURI().toURL());
            loader = new URLClassLoader(urls.toArray(new URL[0]), this.getClass().getClassLoader());
            return loader;
        }
        catch (MalformedURLException e) {
            String message = "Battery Reader MalformedURLException path: " + path;
            KSDAccessException ex = new KSDAccessException(message);
            LOG.info((Object)message);
            throw ex;
        }
    }

    public String find(BatteryData codes, Locale locale) {
        int id = 0;
        boolean found = false;
        if (this.rules != null) {
            for (int i = 0; i < this.rules.length; ++i) {
                if (!this.rules[i].matches(codes)) continue;
                id = this.rules[i].getActivityID();
                found = true;
                LOG.debug((Object)("matching id\"" + id + "\" found for codes:" + codes));
                break;
            }
        }
        if (!found) {
            LOG.debug((Object)("no rule found for:" + codes));
            codes.setAction(null, locale);
            return null;
        }
        String action = null;
        try {
            action = this.findAction(id, locale);
        }
        catch (KSDPropertyFormatException e) {
            // empty catch block
        }
        codes.setAction(action, locale);
        return action;
    }

    private String findAction(int id, Locale locale) throws KSDPropertyFormatException {
        ResourceBundle bundle = this.actions.get(locale);
        if (bundle == null) {
            LOG.warn((Object)("unsupported locale:" + locale.getDisplayName()));
            return null;
        }
        String result = null;
        try {
            result = bundle.getString("" + id);
        }
        catch (MissingResourceException e) {
            String message = "Missing resource battery_action for locale " + locale + " and code " + id;
            throw new KSDPropertyFormatException(message);
        }
        return result;
    }

    private void readInRules(String path) throws KSDAccessException {
        ArrayList<Rule> rulesList = new ArrayList<Rule>();
        CSVReader reader = null;
        try {
            reader = new CSVReader(new FileReader(path), ';', '\"', false, true);
            while (true) {
                Rule rule = new Rule();
                String[] linevals = reader.getAllFieldsInLine();
                this.checkConsistence(path, linevals);
                rule.setActivityID(Integer.parseInt(linevals[0]));
                ArrayList<Interval> expressionList = new ArrayList<Interval>();
                for (int i = 1; i < 12; i += 4) {
                    Interval interval = this.createInterval(linevals[i], linevals[i + 1], linevals[i + 2], linevals[i + 3]);
                    expressionList.add(interval);
                }
                rule.setExpressions(expressionList.toArray(new Interval[0]));
                rulesList.add(rule);
            }
        }
        catch (FileNotFoundException e) {
            String message = "BatteryReader  file not found path: " + path;
            KSDAccessException exk = new KSDAccessException(message);
            LOG.info((Object)message);
            throw exk;
        }
        catch (EOFException e) {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e2) {}
            }
        }
        catch (IOException e) {
            try {
                String message = "Battery Reader IOException path: " + path;
                KSDAccessException ex = new KSDAccessException(message);
                LOG.info((Object)message);
                throw ex;
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception e3) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        this.rules = rulesList.toArray(new Rule[0]);
    }

    private void checkConsistence(String path, String[] linevals) throws KSDAccessException {
        if (linevals == null || linevals.length != 13) {
            String buf = "";
            for (int i = 0; i < linevals.length; ++i) {
                buf = buf + (i > 0 ? ";" : "") + linevals[i];
            }
            String message = "Battery reader invalid data";
            KSDAccessException ex = new KSDAccessException(message);
            LOG.info((Object)message);
            throw ex;
        }
    }

    private Interval createInterval(String flag1, String value1, String flag2, String value2) throws KSDAccessException {
        if (flag1.equals("")) {
            flag1 = null;
        }
        if (flag2.equals("")) {
            flag2 = null;
        }
        if (value1.equals("")) {
            value1 = null;
        }
        if (value2.equals("")) {
            value2 = null;
        }
        boolean includeLowerBound = true;
        boolean includeUpperBound = true;
        this.checkvalues(flag1, value1);
        this.checkvalues(flag2, value2);
        Integer from = this.toInt(value1);
        Integer to = this.toInt(value2);
        if (flag1 != null) {
            if (GT.equals(flag1)) {
                includeLowerBound = false;
            } else if (EQ.equals(flag1)) {
                includeLowerBound = true;
            } else if (GE.equals(flag1)) {
                includeLowerBound = true;
            } else {
                String message = "Battery reader invalid data: " + flag1;
                KSDAccessException ex = new KSDAccessException(message);
                LOG.info((Object)message);
                throw ex;
            }
        }
        if (flag2 != null) {
            if (LT.equals(flag2)) {
                includeUpperBound = false;
            } else if (EQ.equals(flag2)) {
                includeUpperBound = true;
            } else if (LE.equals(flag2)) {
                includeUpperBound = true;
            } else {
                String message = "BatteryReader data not valid : " + flag2;
                KSDAccessException ex = new KSDAccessException(message);
                LOG.info((Object)message);
                throw ex;
            }
        }
        return new Interval(from, to, includeLowerBound, includeUpperBound);
    }

    private Integer toInt(String value) {
        if (value == null) {
            return null;
        }
        if (value.endsWith("h")) {
            value = value.substring(0, value.length() - 1);
        }
        return Integer.valueOf(value, 16);
    }

    private void checkvalues(String flag, String value) throws KSDAccessException {
        if (flag == null ^ value == null) {
            String message = "Battery reader invalid  value: " + value;
            KSDAccessException ex = new KSDAccessException(message);
            LOG.info((Object)message);
            throw ex;
        }
        if (flag == null && value == null) {
            return;
        }
        try {
            this.toInt(value);
        }
        catch (NumberFormatException e) {
            String message = "BatteryReader NumberFormatException value: " + value;
            KSDAccessException ex = new KSDAccessException(message);
            LOG.info((Object)message);
            throw ex;
        }
    }

    public static void reset() {
        instance = null;
    }
}

