/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.external.cache;

import com.bmw.gki.ka.exception.GKIException;
import com.bmw.gki.ka.util.PreProdHolder;
import com.bmw.gki.ka.util.PreProdLogEntry;
import com.bmw.gki.ka.util.PreProdLogMessages;
import com.bmw.gki.klib.api.exception.KSDDataException;
import com.bmw.gki.klib.api.exception.KSDPropertyFormatException;
import com.bmw.gki.klib.api.exception.SettingsException;
import com.bmw.gki.klib.api.exception.WrongVinFormatException;
import com.bmw.gki.klib.data.ksd.cbs.BOSValue;
import com.bmw.gki.klib.data.ksd.key.FgnrPraefix;
import com.bmw.gki.klib.external.cache.KSDReaderIF;
import com.bmw.gki.klib.util.Utilities;
import com.bmw.gki.logging.GKILogManager;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;

public class FgnrPraefixReader
implements KSDReaderIF {
    private static Log log = GKILogManager.getInstance().getLogger(FgnrPraefixReader.class);
    private static Map<String, FgnrPraefix> fgnrPraefixe = new HashMap<String, FgnrPraefix>();

    public static void einlesenTabelle(String path) throws KSDPropertyFormatException, SettingsException {
        if (path == null || path.length() == 0) {
            String message = "FgnrPraefixReader: Pfad in Einstellungen nicht gesetzt: ablageFgnrPraefixe";
            throw new SettingsException(message);
        }
        BufferedReader reader = null;
        try {
            reader = new LineNumberReader(new FileReader(path));
            while (reader.ready()) {
                String line = ((LineNumberReader)reader).readLine();
                int lineNr = ((LineNumberReader)reader).getLineNumber();
                if (Utilities.isCommentLine(line)) continue;
                StringTokenizer tokenizer = new StringTokenizer(line, ";");
                if (tokenizer.countTokens() > 3) {
                    String message;
                    if (PreProdHolder.getIsPreProd()) {
                        message = PreProdLogMessages.getParameterString("CODE_READING_REF_FILES_NOT_VALID", new Object[]{path, "" + lineNr, "token count"});
                        PreProdHolder.addLogEntry(new PreProdLogEntry("ERROR", "CODE_READING_REF_FILES_NOT_VALID", message));
                    }
                    message = "FGNR Praefix reader token count > 3";
                    KSDPropertyFormatException pex = new KSDPropertyFormatException(message);
                    log.info((Object)message);
                    throw pex;
                }
                String marke1 = null;
                String praefix1 = null;
                String produktArt = null;
                try {
                    praefix1 = tokenizer.nextToken();
                    if (praefix1 != null) {
                        praefix1 = praefix1.trim();
                    }
                    if ((marke1 = tokenizer.nextToken()) != null) {
                        marke1 = marke1.trim();
                    }
                    if (tokenizer.hasMoreTokens() && (produktArt = tokenizer.nextToken()) != null) {
                        produktArt = produktArt.trim();
                    }
                }
                catch (Exception e) {
                    log.info((Object)"fgnrPrefix - NoSuchTokenException");
                }
                if (marke1 == null || marke1.equals("")) {
                    marke1 = "B";
                }
                BOSValue.testAndGetString(praefix1, 3, 3, path, lineNr);
                BOSValue.testAndGetChar(marke1, "BMRI", path, lineNr);
                if (produktArt != null) {
                    BOSValue.testAndGetChar(produktArt, "01", path, lineNr);
                }
                fgnrPraefixe.put(praefix1, new FgnrPraefix(praefix1, marke1, produktArt));
            }
        }
        catch (FileNotFoundException ex) {
            String message = "FgnrPraefixReader - file not found";
            KSDPropertyFormatException pex = new KSDPropertyFormatException(message, ex);
            log.info((Object)message);
            throw pex;
        }
        catch (IOException ex) {
            String message = "FgnrPraefixReader - IO Exception";
            KSDPropertyFormatException pex = new KSDPropertyFormatException(message, ex);
            log.info((Object)message);
            throw pex;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FgnrPraefix find(String id) throws GKIException {
        FgnrPraefix fgnr = null;
        if (fgnrPraefixe.size() > 0) {
            fgnr = fgnrPraefixe.get(id);
            if (fgnr != null) return fgnr;
            if (PreProdHolder.getIsPreProd()) {
                String message = PreProdLogMessages.getParameterString("CODE_FGNR_PRAEFIX_NOT_FOUND", new Object[]{id});
                PreProdHolder.addLogEntry(new PreProdLogEntry("INFO", "CODE_FGNR_PRAEFIX_NOT_FOUND", message));
                return new FgnrPraefix(id, "B");
            }
            String message = "Fgnr prefix is null";
            log.info((Object)message);
            throw new WrongVinFormatException(message);
        }
        String message = "fgnrPrefix not set";
        log.info((Object)"fgnrPrefix not set");
        throw new KSDDataException(message);
    }

    public static void reset() {
        fgnrPraefixe = new HashMap<String, FgnrPraefix>();
    }
}

