/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.external.cache;

import com.bmw.gki.klib.api.exception.SystemException;
import com.bmw.gki.klib.common.Einstellungen;
import com.bmw.gki.klib.config.GKICache;
import com.bmw.gki.klib.config.GKICacheObject;
import com.bmw.gki.klib.external.cache.KSDPathes;
import com.bmw.gki.logging.GKILogManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;

class KSDConfiguration
implements KSDPathes {
    private static Log log = GKILogManager.getInstance().getLogger(KSDConfiguration.class);
    public static final String KSDCONFIGURATION_ADAPTER_JAR = "ksdAdapterJar";
    private String ksdPath;
    private String keyAnalyserJar;
    private String serviceKSDJar;
    private String ksdAdapterJar;
    GKICache cacheConfig;
    Map<String, String> cacheOverride;
    private static KSDConfiguration instance = new KSDConfiguration();
    private String keyFilterPath;
    private String keyReferencePath;
    private String gkiKeyReferencePath;
    private String ccMessagesPath;
    private String keyFormatPath;
    private String keyVariantPath;
    private String regionVariantPath;
    private String siConnectionPath;
    private String vehicleNumberPrefixPath;
    private String versionIni;
    private String ksd2Ini;
    private String keyAnalyzerClassName;
    private String serviceKSDClassName;
    private String serviceStubClassName;
    private String fileKeyformatsConfigKey;
    private String fileKeyformatsConfigValue;
    private String keyAnalyzerMethod;
    private String ilevelDirectory;
    private String ilevelMapping;
    private String navidvdPath;
    private String ablageBSIVerknuepfungen;
    private String batteryStateRetrieverClassName;
    private String batteryStateRetrieverJar;
    private String tmpDirectory;

    public static KSDConfiguration getInstance() {
        if (instance == null) {
            instance = new KSDConfiguration();
        }
        return instance;
    }

    private KSDConfiguration() {
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        KSDConfiguration kSDConfiguration = this;
        synchronized (kSDConfiguration) {
            Properties props = new Properties();
            try {
                props.load(this.getClass().getClassLoader().getResourceAsStream("GKISettings.properties"));
            }
            catch (FileNotFoundException e) {
                String message = "GKI Settings not found.";
                log.info((Object)message);
                throw new SystemException(message, e);
            }
            catch (IOException e) {
                String message = "GKI Settings  IO Error.";
                throw new SystemException(message, e);
            }
            this.keyFilterPath = props.getProperty("ablageSchluesselVarFilter");
            this.keyReferencePath = props.getProperty("ablageKeyReferenz");
            this.gkiKeyReferencePath = props.getProperty("ablageKeyRefernceGKI");
            this.keyFormatPath = props.getProperty("ablageSchluesselVarFormat");
            this.keyVariantPath = props.getProperty("ablageSchluesselVar");
            this.regionVariantPath = props.getProperty("ablageLaenderVar");
            this.siConnectionPath = props.getProperty("siConnectionPath");
            this.vehicleNumberPrefixPath = props.getProperty("ablageFgnrPraefixe");
            this.versionIni = props.getProperty("versionIni");
            this.ksd2Ini = props.getProperty("ksd2Ini");
            this.keyAnalyzerClassName = props.getProperty("keyAnalyzerClassName");
            this.keyAnalyzerMethod = props.getProperty("keyAnalyzerMethod");
            this.serviceKSDClassName = props.getProperty("serviceKSDClassName");
            this.serviceStubClassName = props.getProperty("serviceStubClassName");
            this.fileKeyformatsConfigKey = props.getProperty("????");
            this.fileKeyformatsConfigValue = props.getProperty("????");
            this.ilevelDirectory = props.getProperty("????");
            this.ilevelMapping = props.getProperty("????");
            this.navidvdPath = props.getProperty("navidvdPath");
            this.keyAnalyserJar = props.getProperty("keyAnalyserJar");
            this.serviceKSDJar = props.getProperty("serviceKSDJar");
            this.ksdAdapterJar = props.getProperty(KSDCONFIGURATION_ADAPTER_JAR);
            this.ablageBSIVerknuepfungen = props.getProperty("ablageBSIVerknuepfungen");
            this.batteryStateRetrieverClassName = props.getProperty("batteryStateRetrieverClassName");
            this.batteryStateRetrieverJar = props.getProperty("batteryStateRetrieverJar");
            this.ccMessagesPath = props.getProperty("ablageCCMessages");
            if (this.ccMessagesPath == null || this.ccMessagesPath.equals("")) {
                this.ccMessagesPath = "/SAM/CC";
            }
            this.tmpDirectory = System.getenv("TEMP");
            if (this.tmpDirectory == null || this.tmpDirectory.isEmpty()) {
                this.tmpDirectory = System.getenv("TMP");
            }
            this.cacheConfig = new GKICache();
            this.cacheConfig.setSystemTempDirectory(this.tmpDirectory);
            String getEnv = System.getenv("GKI_TEST_DEVELOPER_BOSCACHE_OVERRIDE");
            if (getEnv != null) {
                GKICacheObject bosCache = new GKICacheObject("CACHE_BOSVALUECACHE");
                bosCache.setCacheActivated(System.getenv("GKI_BOSVALUECACHE_ACTIVATED"));
                bosCache.setFileDirectory(System.getenv("GKI_BOSVALUECACHE_DIRECTORY"));
                bosCache.setFileName(System.getenv("GKI_BOSVALUECACHE_FILE"));
                bosCache.setDefaultFileName("bosvalcache.dat");
                this.cacheConfig.addCacheObject("CACHE_BOSVALUECACHE", bosCache);
            }
        }
    }

    @Override
    public String getKeyFilterPath() {
        return this.keyFilterPath;
    }

    public String getVersionIni() {
        return this.versionIni;
    }

    @Override
    public String getKeyReferencePath() {
        return this.keyReferencePath;
    }

    public String getCcMessagesPath() {
        return this.ccMessagesPath;
    }

    @Override
    public String getKeyFormatPath() {
        return this.keyFormatPath;
    }

    @Override
    public String getKeyVariantPath() {
        return this.keyVariantPath;
    }

    @Override
    public String getRegionVariantPath() {
        return this.regionVariantPath;
    }

    @Override
    public String getSIConnectionsPath() {
        return this.siConnectionPath;
    }

    @Override
    public String getVehicleNumberPrefixPath() {
        return this.vehicleNumberPrefixPath;
    }

    public String getVehicleNumberPrefixPathGKI() {
        return this.gkiKeyReferencePath + "/vehiclenumberprefix.txt";
    }

    public String getVehicleNumberPrefixPathWithProductTypeGKI() {
        return this.gkiKeyReferencePath + "/vehiclenumberprefixwithproducttype.txt";
    }

    public String getIlevelDirectory() {
        return this.ilevelDirectory;
    }

    public String getKeyAnalyzerClassName() {
        return this.keyAnalyzerClassName;
    }

    public String getFileKeyformatsConfigKey() {
        return this.fileKeyformatsConfigKey;
    }

    public String getFileKeyformatsConfigValue() {
        return this.fileKeyformatsConfigValue;
    }

    public String getIlevelMapping() {
        return this.ilevelMapping;
    }

    public String getKeyAnalyzerMethod() {
        return this.keyAnalyzerMethod;
    }

    public String getServiceKSDClassName() {
        return this.serviceKSDClassName;
    }

    public String getServiceStubClassName() {
        return this.serviceStubClassName;
    }

    public static Locale[] getSupportedLocales() {
        return Einstellungen.getSupportedLocales();
    }

    public String getNavidvdPath() {
        return this.navidvdPath;
    }

    public String getKeyAnalyserJar() {
        return this.keyAnalyserJar;
    }

    public String getServiceKSDJar() {
        return this.serviceKSDJar;
    }

    public void setServiceKSDClassName(String serviceKSDClassName) {
        this.serviceKSDClassName = serviceKSDClassName;
    }

    public String getTemporaryDirectory() {
        return this.tmpDirectory;
    }

    public void setTempDirectory(String tempDirectory) {
        this.tmpDirectory = tempDirectory;
    }

    public String getKsdAdapterJar() {
        return this.ksdAdapterJar;
    }

    public void setKsdAdapterJar(String adapterName) {
        this.ksdAdapterJar = adapterName;
    }

    public String getAblageBSIVerknuepfungen() {
        return this.ablageBSIVerknuepfungen;
    }

    public void setKSDPath(String path) {
        this.ksdPath = path;
    }

    public String getKSDPath() {
        return this.ksdPath;
    }

    public void reset() {
        instance = null;
    }

    public String getGKIKeyReferencePath() {
        return this.gkiKeyReferencePath;
    }

    public String getBatteryStateRetrieverClassName() {
        return this.batteryStateRetrieverClassName;
    }

    public void setBatteryStateRetrieverClassName(String batteryStateRetrieverClassName) {
        this.batteryStateRetrieverClassName = batteryStateRetrieverClassName;
    }

    public String getBatteryStateRetrieverJar() {
        return this.batteryStateRetrieverJar;
    }

    public String getKsd2Ini() {
        return this.ksd2Ini;
    }

    public void setKsd2Ini(String ksd2Ini) {
        this.ksd2Ini = ksd2Ini;
    }

    public GKICache getCacheConfig() {
        return this.cacheConfig;
    }

    private void showEnv() {
        Map<String, String> env = System.getenv();
        for (String envName : env.keySet()) {
            System.out.format("! %s=%s%n", envName, env.get(envName));
        }
    }
}

