/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.external.cache;

import com.bmw.gki.ka.util.PreProdHolder;
import com.bmw.gki.ka.util.PreProdLogEntry;
import com.bmw.gki.ka.util.PreProdLogMessages;
import com.bmw.gki.klib.api.exception.KSDPropertyFormatException;
import com.bmw.gki.klib.external.cache.KSDReaderIF;
import com.bmw.gki.klib.util.Utilities;
import com.bmw.gki.logging.GKILogManager;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.util.Properties;
import org.apache.commons.logging.Log;

public class MModelReader
implements KSDReaderIF {
    private static Log log = GKILogManager.getInstance().getLogger(MModelReader.class);
    public static final String PROP_MMODEL = "mmodel.properties";
    private static Properties mModel = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readInProperties(String path) throws KSDPropertyFormatException {
        block16: {
            BufferedReader reader = null;
            try {
                if (path != null && path.length() > 0) {
                    reader = new LineNumberReader(new FileReader(path + "/" + PROP_MMODEL));
                    while (reader.ready()) {
                        String line = ((LineNumberReader)reader).readLine();
                        if (Utilities.isCommentLine(line)) continue;
                        mModel.setProperty(line.replaceAll(";", ""), "");
                    }
                    break block16;
                }
                if (PreProdHolder.getIsPreProd()) {
                    String message = PreProdLogMessages.getParameterString("CODE_FILE_NOT_FOUND", new Object[]{"" + path});
                    PreProdHolder.addLogEntry(new PreProdLogEntry("INFO", "CODE_FILE_NOT_FOUND", message));
                    break block16;
                }
                String message = "MModel  Reader path not set: " + path;
                KSDPropertyFormatException pex = new KSDPropertyFormatException(message);
                log.info((Object)message);
                throw pex;
            }
            catch (Exception ex) {
                if (PreProdHolder.getIsPreProd()) {
                    String message = PreProdLogMessages.getParameterString("CODE_FILE_NOT_FOUND", new Object[]{"" + path});
                    PreProdHolder.addLogEntry(new PreProdLogEntry("INFO", "CODE_FILE_NOT_FOUND", message));
                    break block16;
                }
                String message = "MModel  Reader  Exception file: " + path + "/" + PROP_MMODEL;
                KSDPropertyFormatException kfe = new KSDPropertyFormatException(message, ex);
                log.info((Object)("exception code: " + kfe.getErrorCode() + ", message: " + message));
                throw kfe;
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public static boolean isMModel(String eSeries, String modelDestignation) {
        if (mModel != null) {
            boolean res = mModel.containsKey(eSeries + modelDestignation);
            log.debug((Object)("M Model: " + eSeries + modelDestignation + " found: " + res));
            return res;
        }
        return false;
    }

    public static void reset() {
        mModel = new Properties();
    }
}

