/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.external.cache;

import com.bmw.gki.klib.api.exception.KSDAccessException;
import com.bmw.gki.klib.data.ksd.navi.NaviDVDData;
import com.bmw.gki.klib.data.ksd.navi.NaviDVDDataKey;
import com.bmw.gki.klib.data.ksd.navi.NaviPartData;
import com.bmw.gki.klib.data.ksd.navi.NaviPartDataKey;
import com.bmw.gki.klib.external.cache.KSDReaderIF;
import com.bmw.gki.klib.util.CSVReader;
import com.bmw.gki.klib.util.Utilities;
import com.bmw.gki.logging.GKILogManager;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Hashtable;
import org.apache.commons.logging.Log;

public class NaviDVDReader
implements KSDReaderIF {
    private static final String UPDATE_FLAG_YES = "Yes";
    private static final String UPDATE_FLAG_NO = "No";
    private static final String UPDATE_FLAG_FEAT = "Feat.";
    private static final String FILE_NAME_BMW_MINI = "navi.csv";
    private static final String FILE_NAME_BMW = "navi_bmw.csv";
    private static final String FILE_NAME_MINI = "navi_mini.csv";
    private static final String FILE_NAME_BMW_I = "navi_bi.csv";
    private static final String FILE_NAME_RR = "navi_rr.csv";
    private static final int[] COLUMNS_DEFAULT = new int[]{0, 1, 2, 3, 4};
    private static final int[] COLUMNS_ALTERNATIVE_BMW = new int[]{0, 1, 2, 3, 6};
    private static final int[] COLUMNS_ALTERNATIVE_MINI = new int[]{0, 1, 4, 5, 6};
    private static final String RUNNING_CHANGE_SUFFIX = ". (Punkt)";
    private static Log log = GKILogManager.getInstance().getLogger(NaviDVDReader.class);
    private static NaviDVDReader instance;
    private Hashtable<NaviDVDDataKey, NaviDVDData> naviDVDData;
    private Hashtable<NaviPartDataKey, NaviPartData> naviDVDDataParts;

    private NaviDVDReader() {
    }

    private FileReadParameter[] createFileReadParameters(String path) {
        FileReadParameter[] fileReadParameters = new FileReadParameter[4];
        String brand = "BMW";
        fileReadParameters[0] = new FileReadParameter(brand, new File(path, FILE_NAME_BMW), COLUMNS_DEFAULT);
        fileReadParameters[0].setAlternative(new FileReadParameter(brand, new File(path, FILE_NAME_BMW_MINI), COLUMNS_ALTERNATIVE_BMW));
        brand = "MINI";
        fileReadParameters[1] = new FileReadParameter(brand, new File(path, FILE_NAME_MINI), COLUMNS_DEFAULT);
        fileReadParameters[1].setAlternative(new FileReadParameter(brand, new File(path, FILE_NAME_BMW_MINI), COLUMNS_ALTERNATIVE_MINI));
        brand = "BI";
        fileReadParameters[2] = new FileReadParameter(brand, new File(path, FILE_NAME_BMW_I), COLUMNS_DEFAULT);
        fileReadParameters[2].setAlternative(new FileReadParameter(brand, new File(path, FILE_NAME_BMW_MINI), COLUMNS_ALTERNATIVE_BMW));
        brand = "RR";
        fileReadParameters[3] = new FileReadParameter(brand, new File(path, FILE_NAME_RR), COLUMNS_DEFAULT);
        return fileReadParameters;
    }

    public void readInTable(String path) throws KSDAccessException {
        this.naviDVDData = new Hashtable();
        this.naviDVDDataParts = new Hashtable();
        FileReadParameter[] fileReadParameters = this.createFileReadParameters(path);
        for (int i = 0; i < fileReadParameters.length; ++i) {
            FileReadParameter fileReadParameter = this.getParametersForExistingFile(fileReadParameters[i]);
            if (fileReadParameter == null) continue;
            this.readInTable(fileReadParameter);
        }
        this.processSuccessorParts();
    }

    private FileReadParameter getParametersForExistingFile(FileReadParameter fileReadParameter) {
        File file;
        String brand;
        do {
            brand = fileReadParameter.getBrand();
            file = fileReadParameter.getFile();
            if (!file.exists()) continue;
            return fileReadParameter;
        } while ((fileReadParameter = fileReadParameter.getAlternative()) != null);
        log.warn((Object)("NaviDVDReader: brand " + brand + ", navi file " + file + " not found and no alternative file defined"));
        return null;
    }

    private String[] filterLineValues(String[] lineValues, FileReadParameter fileReadParameter, File file, int lineNo) throws KSDAccessException {
        if (lineValues == null) {
            String message = "Navi DVD reader line values are null in file: " + file + ", line: " + lineNo;
            KSDAccessException ex = new KSDAccessException(message);
            log.info((Object)message);
            throw ex;
        }
        if (lineValues.length > 0 && Utilities.isCommentLine(lineValues[0])) {
            return null;
        }
        int[] columnIndizes = fileReadParameter.getColumnIndizes();
        String[] result = new String[columnIndizes.length];
        for (int i = 0; i < columnIndizes.length; ++i) {
            int columnIndex = columnIndizes[i];
            if (columnIndex < 0 || columnIndex > lineValues.length - 1) {
                String message = "Navi DVD reader invalid line values in file: " + file + ", line: " + lineNo;
                KSDAccessException ex = new KSDAccessException(message);
                log.info((Object)message);
                throw ex;
            }
            result[i] = lineValues[columnIndex];
        }
        return result;
    }

    private void readInTable(FileReadParameter fileReadParameter) {
        File file = null;
        String brand = null;
        try {
            file = fileReadParameter.getFile();
            brand = fileReadParameter.getBrand();
            int lineNo = 0;
            CSVReader reader = null;
            try {
                reader = new CSVReader(new FileReader(file), ';', '\"', false, true);
                lineNo = 1;
                while (true) {
                    try {
                        String[] values;
                        String[] lineValues = reader.getAllFieldsInLine();
                        if (!(lineNo == 1 && this.checkForCSVHeader(lineValues) || (values = this.filterLineValues(lineValues, fileReadParameter, file, lineNo)) == null)) {
                            this.createNaviDVDData(brand, lineNo, values);
                        }
                    }
                    catch (EOFException e) {
                        break;
                    }
                    catch (KSDAccessException e) {
                        log.info((Object)e.getMessage());
                    }
                    catch (Exception e) {
                        String message = "NaviDVDReader Exception: brand " + brand + ", file " + file + ", line " + lineNo;
                        KSDAccessException ex = new KSDAccessException(message, e);
                        log.info((Object)ex.getMessage(), (Throwable)ex);
                    }
                    ++lineNo;
                }
            }
            catch (FileNotFoundException e) {
                String message = "NaviDVDReader Reader file not found: brand " + brand + ", file " + file;
                KSDAccessException ex = new KSDAccessException(message);
                log.info((Object)ex.getMessage(), (Throwable)ex);
                throw ex;
            }
            catch (Exception e) {
                String message = "NaviDVDReader Exception: brand " + brand + ", file " + file + ", line " + lineNo;
                KSDAccessException ex = new KSDAccessException(message);
                log.info((Object)ex.getMessage(), (Throwable)ex);
                throw ex;
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        catch (KSDAccessException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            String message = "NaviDVDReader Exception: brand " + brand + ", file " + file;
            KSDAccessException ex = new KSDAccessException(message);
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private boolean checkForCSVHeader(String[] lineValues) {
        if (lineValues == null) {
            return false;
        }
        String line = null;
        for (int i = 0; i < lineValues.length; ++i) {
            line = line + " " + lineValues[i];
        }
        return line.indexOf("Bezeichnung") > 0 && line.indexOf("Sach-Nr") > 0;
    }

    private void processSuccessorParts() {
        for (NaviDVDData naviDVD : this.naviDVDData.values()) {
            NaviPartData part = naviDVD.getPartData();
            if (part == null) continue;
            try {
                String brand;
                NaviPartData successorPart;
                String newPartNumber = part.getPartNumberSuccessorDVD();
                if (newPartNumber == null || (successorPart = this.naviDVDDataParts.get(new NaviPartDataKey(brand = part.getBrand(), newPartNumber))) == null) continue;
                NaviDVDData successorDVD = this.naviDVDData.get(successorPart.getNaviDVDKey());
                if (!this.checkForCycle(part, successorDVD)) {
                    part.setSuccessorDVD(successorDVD);
                    continue;
                }
                log.warn((Object)("NaviDVDReader: cycle detected for brand " + brand + ", code " + part.getNaviDVDKey().getCode()));
            }
            catch (Exception e) {
                String message = "NaviDVDReader Exception: processSuccessorParts part " + part;
                KSDAccessException ex = new KSDAccessException(message);
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private boolean checkForCycle(NaviPartData partData, NaviDVDData successorDVD) {
        if (successorDVD == null) {
            return false;
        }
        NaviPartData successorPartData = successorDVD.getPartData();
        if (successorPartData == null) {
            return false;
        }
        if (partData.equals(successorPartData)) {
            return true;
        }
        return this.checkForCycle(partData, successorPartData.getSuccessorDVD());
    }

    private void createNaviDVDData(String brand, int line, String[] linevals) throws KSDAccessException {
        Integer code = null;
        String description = null;
        String partNumber = null;
        String newPartNumber = null;
        String updateFlag = null;
        try {
            code = this.toInt(linevals[0]);
            description = this.emptyStringToNull(linevals[1]);
            partNumber = this.emptyStringToNull(linevals[2]);
            newPartNumber = this.emptyStringToNull(linevals[3]);
            updateFlag = linevals[4];
        }
        catch (Exception e) {
            String message = "Navi DVD reader invalid line: " + line;
            KSDAccessException ex = new KSDAccessException(message, e);
            log.info((Object)message);
            throw ex;
        }
        NaviDVDData data = new NaviDVDData(new NaviDVDDataKey(brand, code));
        data.setDescription(description);
        if (partNumber != null) {
            NaviPartDataKey naviPartDataKey = new NaviPartDataKey(brand, partNumber);
            NaviPartData partData = this.naviDVDDataParts.get(naviPartDataKey);
            if (partData == null || description.endsWith(RUNNING_CHANGE_SUFFIX)) {
                partData = new NaviPartData(naviPartDataKey);
                partData.setPartNumberSuccessorDVD(newPartNumber);
                partData.setNaviDVDKey(data.getKey());
                this.naviDVDDataParts.put(naviPartDataKey, partData);
            } else {
                log.info((Object)("NaviDVDReader: !! NAVI with duplicate part number: " + partNumber));
            }
            data.setPartData(partData);
        }
        if (updateFlag != null) {
            updateFlag = updateFlag.trim();
        }
        if (updateFlag == null || updateFlag.equals("")) {
            updateFlag = UPDATE_FLAG_NO;
        }
        if (UPDATE_FLAG_YES.equals(updateFlag)) {
            data.setSoftwareUpdateNecessary(true);
            data.setNewFeatures(true);
        } else if (UPDATE_FLAG_NO.equals(updateFlag)) {
            data.setSoftwareUpdateNecessary(false);
            data.setNewFeatures(false);
        } else if (UPDATE_FLAG_FEAT.equals(updateFlag)) {
            data.setSoftwareUpdateNecessary(false);
            data.setNewFeatures(true);
        } else {
            String message = "Navi DVD Reader line: " + updateFlag;
            KSDAccessException ex = new KSDAccessException(message);
            log.info((Object)message);
            throw ex;
        }
        this.naviDVDData.put(data.getKey(), data);
    }

    private Integer toInt(String value) {
        if (value == null) {
            return null;
        }
        return Integer.valueOf(value);
    }

    private String emptyStringToNull(String value) {
        if (value == null || "".equals(value)) {
            return null;
        }
        return value;
    }

    public NaviDVDData find(Integer code) {
        String message = "NaviDVDReader.find(Integer code) not supported, please call NaviDVDReader.find(String brand, Integer code) instead";
        throw new UnsupportedOperationException(message);
    }

    public NaviDVDData find(String brand, Integer code) {
        if ((brand = this.mapBrand(brand)) != null && code != null) {
            NaviDVDData result = this.naviDVDData.get(new NaviDVDDataKey(brand, code));
            return result;
        }
        return null;
    }

    private String mapBrand(String brand) {
        if (brand != null) {
            if (brand.startsWith("I")) {
                return "BI";
            }
            if (brand.startsWith("B")) {
                return "BMW";
            }
            if (brand.startsWith("M")) {
                return "MINI";
            }
            if (brand.startsWith("R")) {
                return "RR";
            }
            if (brand.startsWith("X")) {
                return "MOT";
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NaviDVDReader getInstance() {
        if (instance != null) return instance;
        Class<NaviDVDReader> clazz = NaviDVDReader.class;
        synchronized (NaviDVDReader.class) {
            instance = new NaviDVDReader();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static void reset() {
        instance = null;
    }

    private class FileReadParameter {
        private String brand;
        private File file;
        private int[] columnIndizes;
        private FileReadParameter alternative;

        FileReadParameter(String brand, File file, int[] columnIndizes) {
            this.brand = brand;
            this.file = file;
            this.columnIndizes = columnIndizes;
        }

        public String getBrand() {
            return this.brand;
        }

        public File getFile() {
            return this.file;
        }

        public int[] getColumnIndizes() {
            return this.columnIndizes;
        }

        public FileReadParameter getAlternative() {
            return this.alternative;
        }

        public void setAlternative(FileReadParameter alternative) {
            this.alternative = alternative;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("[FileReadParameter:");
            buffer.append(" brand: ");
            buffer.append(this.brand);
            buffer.append(" file: ");
            buffer.append(this.file);
            buffer.append(" { ");
            for (int i0 = 0; this.columnIndizes != null && i0 < this.columnIndizes.length; ++i0) {
                buffer.append(" columnIndizes[" + i0 + "]: ");
                buffer.append(this.columnIndizes[i0]);
            }
            buffer.append(" } ");
            buffer.append(" alternative: ");
            buffer.append(this.alternative);
            buffer.append("]");
            return buffer.toString();
        }
    }
}

