/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.external.cache;

import com.bmw.gki.klib.api.exception.KSDPropertyFormatException;
import com.bmw.gki.klib.data.ksd.cbs.SSIFormula;
import com.bmw.gki.klib.external.cache.KSDReaderIF;
import com.bmw.gki.klib.util.Utilities;
import com.bmw.gki.logging.GKILogManager;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.logging.Log;

public class SSIInformationReader
implements KSDReaderIF {
    private static Log log = GKILogManager.getInstance().getLogger(SSIInformationReader.class);
    private static Properties ssiCountryCodes = new Properties();
    private static Properties ssiSaCodes = new Properties();
    private static Vector<SSIFormula> ssiFormula = new Vector();
    private static final String SII_COUNTRIES = "ssi_countries.properties";
    private static final String SII_SA_CODES = "ssi_sa.properties";
    private static final String SII_FORMULA = "ssi_formula_1.properties";
    private static final int NUM_TOKENS_SSI_FORMULA = 7;

    public static void einlesenTabelle(String path) throws KSDPropertyFormatException {
        SSIInformationReader.readInProperties(path + "/" + SII_COUNTRIES, ssiCountryCodes);
        log.info((Object)"reading SSI countries into cache.");
        SSIInformationReader.readInProperties(path + "/" + SII_SA_CODES, ssiSaCodes);
        log.info((Object)"reading SSI SA codes into cache.");
        SSIInformationReader.readInTable(path + "/" + SII_FORMULA);
        log.info((Object)"reading SSI formulas into cache.");
    }

    private static void readInTable(String file) throws KSDPropertyFormatException {
        BufferedReader reader = null;
        try {
            reader = new LineNumberReader(new FileReader(file));
            while (reader.ready()) {
                String line = ((LineNumberReader)reader).readLine();
                if (Utilities.isCommentLine(line)) continue;
                StringTokenizer tokenizer = new StringTokenizer(line, ";");
                if (tokenizer.countTokens() != 7) {
                    String message = "SSIInformationReader token count != " + String.valueOf(7);
                    message = message + " - ignore formula: !!! " + line + " !!! - no ssi interpretation";
                    log.info((Object)message);
                    continue;
                }
                String saOption = tokenizer.nextToken().trim();
                String engineTyp = tokenizer.nextToken().trim();
                String countries = tokenizer.nextToken().trim();
                String cbsId = tokenizer.nextToken().trim();
                String linkedId = tokenizer.nextToken().trim();
                String period = tokenizer.nextToken().trim();
                String formula = tokenizer.nextToken().trim();
                int index = -1;
                if (!ssiFormula.isEmpty() && (index = SSIInformationReader.proof(saOption, engineTyp, cbsId, linkedId, period, countries)) >= 0) {
                    SSIFormula oldFormula = ssiFormula.get(index);
                    log.info((Object)("Duplicate record found: " + saOption + "," + engineTyp + "," + cbsId + "," + linkedId + "," + period + ". Formula " + oldFormula.getFormula() + " will be overwritten with " + formula));
                    ssiFormula.removeElementAt(index);
                }
                ssiFormula.addElement(new SSIFormula(saOption, engineTyp, cbsId, linkedId, period, formula, countries));
            }
        }
        catch (IOException ex) {
            String message = "SSIInformationReader IO Exception file: " + file;
            KSDPropertyFormatException kfe = new KSDPropertyFormatException(message, ex);
            log.info((Object)("exception code: " + kfe.getErrorCode() + ", message: " + message));
            throw kfe;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private static void readInProperties(String file, Properties prop) throws KSDPropertyFormatException {
        BufferedReader reader = null;
        try {
            reader = new LineNumberReader(new FileReader(file));
            while (reader.ready()) {
                String line = ((LineNumberReader)reader).readLine();
                if (Utilities.isCommentLine(line)) continue;
                StringTokenizer tokenizer = new StringTokenizer(line, ";");
                String key = null;
                String value = null;
                if (tokenizer.countTokens() == 1) {
                    key = tokenizer.nextToken().trim();
                    value = "";
                } else {
                    if (tokenizer.countTokens() != 2) continue;
                    key = tokenizer.nextToken().trim();
                    value = tokenizer.nextToken().trim();
                }
                prop.setProperty(key, value);
            }
        }
        catch (IOException ex) {
            String message = "SSIInformationReader IO Exception file: " + file;
            KSDPropertyFormatException kfe = new KSDPropertyFormatException(message, ex);
            log.info((Object)("exception code: " + kfe.getErrorCode() + ", message: " + message));
            throw kfe;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static boolean isSSICountry(String countryCode) {
        boolean isCountry = false;
        if (ssiCountryCodes != null && countryCode != null) {
            isCountry = ssiCountryCodes.containsKey(countryCode);
        }
        return isCountry;
    }

    public static boolean isSSISA(String saCode) {
        boolean isSA = false;
        if (ssiSaCodes != null && saCode != null) {
            isSA = ssiSaCodes.containsKey(saCode);
        }
        return isSA;
    }

    public static Set<?> getAllSSISA() {
        if (ssiSaCodes != null) {
            return ssiSaCodes.keySet();
        }
        return null;
    }

    public static Set<?> getAllSSICountries() {
        if (ssiCountryCodes != null) {
            return ssiCountryCodes.keySet();
        }
        return null;
    }

    public static Properties getAllSSICountriesKeyValues() {
        return ssiCountryCodes;
    }

    public static Vector<SSIFormula> getSSIFormulas(String saOptionCode) {
        Vector<SSIFormula> list = new Vector<SSIFormula>();
        if (ssiFormula == null || saOptionCode == null) {
            return list;
        }
        for (int i = 0; i < ssiFormula.size(); ++i) {
            SSIFormula rec = ssiFormula.elementAt(i);
            if (!rec.getSaOption().equals(saOptionCode)) continue;
            list.add(rec);
        }
        return list;
    }

    public static void reset() {
        ssiCountryCodes = new Properties();
        ssiSaCodes = new Properties();
        ssiFormula = new Vector();
    }

    private static int proof(String saOption, String engineType, String cbsId, String linkedId, String period, String countries) {
        for (int i = 0; i < ssiFormula.size(); ++i) {
            SSIFormula testFormula = ssiFormula.elementAt(i);
            if (!saOption.equals(testFormula.getSaOption()) || !engineType.equals(testFormula.getEngineType()) || !cbsId.equals(testFormula.getCbsId()) || !linkedId.equals(testFormula.getLinkedId()) || !period.equals(testFormula.getPeriod()) || !countries.equals(testFormula.getCountries())) continue;
            return i;
        }
        return -1;
    }
}

