/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.external.cache;

import com.bmw.gki.klib.api.SchluesselVariante;
import com.bmw.gki.klib.api.exception.KSDPropertyFormatException;
import com.bmw.gki.klib.api.exception.SettingsException;
import com.bmw.gki.klib.data.ksd.cbs.BOSValue;
import com.bmw.gki.klib.data.ksd.key.SchluesselFilter;
import com.bmw.gki.klib.external.cache.KSDReaderIF;
import com.bmw.gki.klib.external.cache.SchluesselVarianteReader;
import com.bmw.gki.klib.util.Utilities;
import com.bmw.gki.logging.GKILogManager;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.logging.Log;

public class SchluesselFilterReader
implements KSDReaderIF {
    private static Log log = GKILogManager.getInstance().getLogger(SchluesselFilterReader.class);
    private static Vector<SchluesselFilter> schluesselFilter = new Vector();
    private static Properties schluesselFormats = new Properties();

    public static SchluesselVariante filter(SchluesselVariante schluesselvariante, int baustand) {
        for (SchluesselFilter filter : schluesselFilter) {
            int baustandAnfang = filter.getBaustandAnfang();
            int baustandEnde = filter.getBaustandEnde();
            if (baustandAnfang >= baustand || baustandEnde <= baustand || !schluesselvariante.equals(filter.getUrsprung())) continue;
            return filter.getZiel();
        }
        return schluesselvariante;
    }

    public static void einlesenTabelle(String pathFormats, String pathFilters) throws KSDPropertyFormatException, SettingsException {
        SchluesselFilterReader.einlesenTabelleFilters(pathFilters);
        SchluesselFilterReader.einlesenTabelleFormats(pathFormats);
    }

    private static void einlesenTabelleFilters(String path) throws KSDPropertyFormatException, SettingsException {
        URL root;
        if (path.startsWith(".") && (root = SchluesselFilter.class.getResource("/" + path)) != null) {
            path = root.getFile();
        }
        if (path == null || path.length() == 0) {
            String message = "SchluesselFilterReader path not set: " + path;
            SettingsException ke = new SettingsException(message);
            log.info((Object)("exception code: " + ke.getErrorCode() + " " + message));
            throw ke;
        }
        BufferedReader reader = null;
        try {
            reader = new LineNumberReader(new FileReader(path));
            while (reader.ready()) {
                String line = ((LineNumberReader)reader).readLine();
                int lineNr = ((LineNumberReader)reader).getLineNumber();
                if (Utilities.isCommentLine(line)) continue;
                StringTokenizer tokenizer = new StringTokenizer(line, "=");
                if (tokenizer.countTokens() != 2) {
                    String message = "SchluesselfilterReader token count != 2";
                    KSDPropertyFormatException pex = new KSDPropertyFormatException(message);
                    log.info((Object)("exception code: " + pex.getErrorCode() + " message: " + message));
                    throw pex;
                }
                String key = tokenizer.nextToken().trim();
                String data = tokenizer.nextToken();
                int idursprung = Integer.decode("0x" + key);
                SchluesselVariante ursprung = SchluesselVarianteReader.findOrCreatePseudo(idursprung);
                tokenizer = new StringTokenizer(data, ";");
                if (tokenizer.countTokens() < 4) {
                    String message = "SchluesselfilterReader token count < 4";
                    KSDPropertyFormatException pex = new KSDPropertyFormatException(message);
                    log.info((Object)("exception code: " + pex.getErrorCode() + " message: " + message));
                    throw pex;
                }
                int baustandAnfang = BOSValue.testAndGetBaustand(tokenizer.nextToken().trim(), path, lineNr);
                int baustandEnde = BOSValue.testAndGetBaustand(tokenizer.nextToken().trim(), path, lineNr);
                int idziel = Integer.decode("0x" + tokenizer.nextToken());
                int anzeigeId = Integer.parseInt(tokenizer.nextToken().trim());
                SchluesselVariante ziel = SchluesselVarianteReader.find(idziel);
                schluesselFilter.addElement(new SchluesselFilter(ursprung, baustandAnfang, baustandEnde, ziel, anzeigeId));
            }
        }
        catch (NumberFormatException nfe) {
            String message = "SchluesselfilterReader NumberFormatException";
            KSDPropertyFormatException kfe = new KSDPropertyFormatException(message);
            log.info((Object)("exception code: " + kfe.getErrorCode() + " message: " + message));
            throw kfe;
        }
        catch (FileNotFoundException ex) {
            String message = "SchluesselFilterReader File not found path: " + path;
            KSDPropertyFormatException kfe = new KSDPropertyFormatException(message, ex);
            log.info((Object)("exception code: " + kfe.getErrorCode() + " message: " + message));
            throw kfe;
        }
        catch (IOException ex) {
            String message = "SchluesselFilterReader IO Exception path: " + path;
            KSDPropertyFormatException kfe = new KSDPropertyFormatException(message, ex);
            log.info((Object)("exception code: " + kfe.getErrorCode() + " message: " + message));
            throw kfe;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private static void einlesenTabelleFormats(String path) throws KSDPropertyFormatException, SettingsException {
        URL root;
        if (path.startsWith(".") && (root = SchluesselFilter.class.getResource("/" + path)) != null) {
            path = root.getFile();
        }
        if (path == null || path.length() == 0) {
            String message = "SchluesselFilterReader path not set: " + path;
            SettingsException ke = new SettingsException(message);
            log.info((Object)("exception code: " + ke.getErrorCode() + " message: " + message));
            throw ke;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(path);
            schluesselFormats.load(in);
        }
        catch (FileNotFoundException ex) {
            String message = "SchluesselFilterReader file not found path: " + path;
            KSDPropertyFormatException kfe = new KSDPropertyFormatException(message, ex);
            log.info((Object)("exception code: " + kfe.getErrorCode() + " message: " + message));
            throw kfe;
        }
        catch (IOException ex) {
            String message = "SchluesselFilterReader IO Exception path: " + path;
            KSDPropertyFormatException kfe = new KSDPropertyFormatException(message, ex);
            log.info((Object)("exception code: " + kfe.getErrorCode() + " message: " + message));
            throw kfe;
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static void reset() {
        schluesselFilter = new Vector();
        schluesselFormats = new Properties();
    }
}

