/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.external.cache;

import com.bmw.gki.ka.util.PreProdHolder;
import com.bmw.gki.ka.util.PreProdLogEntry;
import com.bmw.gki.ka.util.PreProdLogMessages;
import com.bmw.gki.klib.api.SchluesselVariante;
import com.bmw.gki.klib.api.exception.KSDPropertyFormatException;
import com.bmw.gki.klib.api.exception.NotFoundException;
import com.bmw.gki.klib.api.exception.SettingsException;
import com.bmw.gki.klib.external.cache.KSDReaderIF;
import com.bmw.gki.klib.util.Utilities;
import com.bmw.gki.logging.GKILogManager;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.Hashtable;
import org.apache.commons.logging.Log;

public class SchluesselVarianteReader
implements KSDReaderIF {
    private static Log log = GKILogManager.getInstance().getLogger(SchluesselVarianteReader.class);
    private static Hashtable<Integer, SchluesselVariante> schluesselVarianten = new Hashtable();

    public static SchluesselVariante findOrCreatePseudo(int id) throws KSDPropertyFormatException {
        SchluesselVariante variante = schluesselVarianten.get(new Integer(id));
        if (variante == null) {
            variante = new SchluesselVariante(id, 1, "", true, 0, id);
            schluesselVarianten.put(new Integer(id), variante);
        }
        return variante;
    }

    public static void einlesenTabelle(String path) throws SettingsException, KSDPropertyFormatException {
        URL root;
        if (path.startsWith(".") && (root = SchluesselVariante.class.getResource("/" + path)) != null) {
            path = root.getFile();
        }
        if (path == null || path.length() == 0) {
            String message = "SchluesselVariantenReader path not set: " + path;
            SettingsException ke = new SettingsException(message);
            log.info((Object)("exception code: " + ke.getErrorCode() + " " + message));
            throw ke;
        }
        int lineNumber = -1;
        BufferedReader reader = null;
        try {
            reader = new LineNumberReader(new FileReader(path));
            while (reader.ready()) {
                boolean pseudo = false;
                String line = ((LineNumberReader)reader).readLine();
                lineNumber = ((LineNumberReader)reader).getLineNumber();
                if (Utilities.isCommentLine(line)) continue;
                int id = Integer.parseInt(line.substring(0, 5));
                String daten = line.substring(5);
                log.debug((Object)("** ADD schluesselvariante id: " + id + "daten: " + daten + " pseudo: " + pseudo + "lineNumber " + lineNumber));
                SchluesselVariante schluesselVariante = new SchluesselVariante(id, 1, daten, pseudo, lineNumber, id);
                schluesselVarianten.put(new Integer(id), schluesselVariante);
            }
        }
        catch (NumberFormatException nf) {
            if (PreProdHolder.getIsPreProd()) {
                String message = PreProdLogMessages.getParameterString("CODE_READING_REF_FILES_NOT_VALID", new Object[]{path, "" + lineNumber, "not a number"});
                PreProdHolder.addLogEntry(new PreProdLogEntry("INFO", "CODE_READING_REF_FILES_NOT_VALID", message));
            }
        }
        catch (FileNotFoundException fnf) {
            String message = "SchluesselVarianteReader File not found path: " + path;
            KSDPropertyFormatException kfe = new KSDPropertyFormatException(message, fnf);
            log.info((Object)("exception code: " + kfe.getErrorCode() + "message: " + message));
            throw kfe;
        }
        catch (IOException ioe) {
            String message = "SchluesselVarianteReader IO Exception path: " + path;
            KSDPropertyFormatException kfe = new KSDPropertyFormatException(message, ioe);
            log.info((Object)("exception code: " + kfe.getErrorCode() + "message: " + message));
            throw kfe;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static SchluesselVariante find(int id) {
        SchluesselVariante variante = schluesselVarianten.get(new Integer(id));
        if (variante == null) {
            if (PreProdHolder.getIsPreProd()) {
                String message = PreProdLogMessages.getParameterString("CODE_KEY_VARIANT_NOT_FOUND", new Object[]{"" + variante});
                PreProdHolder.addLogEntry(new PreProdLogEntry("ERROR", "CODE_KEY_VARIANT_NOT_FOUND", message));
            }
            throw new NotFoundException("Schluesselvariante not found", new String[]{"" + id});
        }
        return variante;
    }

    public static void reset() {
        schluesselVarianten = new Hashtable();
    }
}

