/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.external.cache;

import com.bmw.gki.klib.api.BSIBerechnungsbasis;
import com.bmw.gki.klib.api.exception.KSDPropertyFormatException;
import com.bmw.gki.klib.data.ksd.bsi.BSIDatensatzfehlerhaftException;
import com.bmw.gki.klib.data.ksd.bsi.BSIVorziehbereich;
import com.bmw.gki.klib.external.cache.KSDConfiguration;
import com.bmw.gki.klib.external.cache.KSDReaderIF;
import com.bmw.gki.logging.GKILogManager;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;

public class ServicePaketKSD
implements KSDReaderIF {
    private static String FILENAME_BSICALC = "/bsicalc.properties";
    private static String FILENAME_BSI_CBS = "/bsicbs.properties";
    private static Log log = GKILogManager.getInstance().getLogger(ServicePaketKSD.class);
    private static Properties berechnungsbasis;
    private static Hashtable<String, Hashtable<String, BSIVorziehbereich>> bsiVorziehwerte;

    public BSIBerechnungsbasis ermittelnBerechnungsbasis(String vertragstyp) throws BSIDatensatzfehlerhaftException {
        String result = berechnungsbasis.getProperty(vertragstyp);
        if (result != null) {
            BSIBerechnungsbasis bsiBerechnungsbasis = this.createBSIBerechnungsbasis(result);
            bsiBerechnungsbasis.setBSIVorziehbereich(this.find(vertragstyp));
            return bsiBerechnungsbasis;
        }
        return null;
    }

    private BSIBerechnungsbasis createBSIBerechnungsbasis(String line) throws BSIDatensatzfehlerhaftException {
        StringTokenizer st = new StringTokenizer(line, ";");
        float[] fl = new float[6];
        int i = 0;
        if (st.countTokens() != 6) {
            throw new BSIDatensatzfehlerhaftException("ServicePaketKSD create Berechnungsbasis (count != 6) ", new String[]{line, "" + st.countTokens()});
        }
        while (st.hasMoreTokens()) {
            fl[i++] = Float.parseFloat(st.nextToken());
        }
        return new BSIBerechnungsbasis(new Double(fl[1]).intValue(), new Double(fl[0]).intValue(), fl[2], fl[3], fl[4], fl[5]);
    }

    public static void einlesenTabelle(String siConnectionsPath, String ksdPath) throws KSDPropertyFormatException {
        ServicePaketKSD servicePaketKSD = new ServicePaketKSD();
        String filename = siConnectionsPath + FILENAME_BSI_CBS;
        Properties vorziehwerte = servicePaketKSD.einlesenProperties(filename);
        Enumeration enumeration = ((Hashtable)vorziehwerte).keys();
        bsiVorziehwerte = new Hashtable();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String line = (String)((Hashtable)vorziehwerte).get(key);
            bsiVorziehwerte.put(key, ServicePaketKSD.createBSIVorziehbereich(line));
        }
        berechnungsbasis = servicePaketKSD.einlesenProperties(ksdPath + KSDConfiguration.getInstance().getAblageBSIVerknuepfungen() + FILENAME_BSICALC);
    }

    private Hashtable<?, ?> find(String vertragstyp) {
        return bsiVorziehwerte.get(vertragstyp);
    }

    private Properties einlesenProperties(String filename) throws KSDPropertyFormatException {
        Properties p = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(filename);
            p.load(in);
        }
        catch (IOException e) {
            String message = "ServicePaketKSD IO Exception: " + filename;
            KSDPropertyFormatException kfe = new KSDPropertyFormatException(message, e);
            log.info((Object)("exception code: " + kfe.getErrorCode() + "message: " + message));
            throw kfe;
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (Exception e) {}
            }
        }
        return p;
    }

    private static Hashtable<String, BSIVorziehbereich> createBSIVorziehbereich(String line) throws KSDPropertyFormatException {
        StringTokenizer st = new StringTokenizer(line, ";");
        Hashtable<String, BSIVorziehbereich> hash = new Hashtable<String, BSIVorziehbereich>();
        while (st.hasMoreTokens()) {
            StringTokenizer stSatz = new StringTokenizer(st.nextToken(), ",");
            if (stSatz.countTokens() != 3) {
                String message = "ServicePaketKSD token count != 2";
                KSDPropertyFormatException kfe = new KSDPropertyFormatException(message);
                log.info((Object)("exception code: " + kfe.getErrorCode() + "message: " + message));
                throw kfe;
            }
            String kennung = stSatz.nextToken();
            hash.put(kennung, new BSIVorziehbereich(Integer.valueOf(stSatz.nextToken()), Integer.valueOf(stSatz.nextToken()), Integer.parseInt(kennung)));
        }
        return hash;
    }

    public static void reset() {
        bsiVorziehwerte = null;
    }
}

