/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.logic;

import com.bmw.gki.ka.exception.GKIException;
import com.bmw.gki.klib.api.AuftragsbasisGrunddatenIF;
import com.bmw.gki.klib.api.BSIBerechnungsbasis;
import com.bmw.gki.klib.api.Fahreigenschaft;
import com.bmw.gki.klib.api.exception.KeineArbeitswerteException;
import com.bmw.gki.klib.api.exception.RegistrationDateException;
import com.bmw.gki.klib.api_current.OrderBaseType;
import com.bmw.gki.klib.api_current.TypeMileage;
import com.bmw.gki.klib.api_current.TypeUnitValue;
import com.bmw.gki.klib.api_current.impl.TypeMileageImpl;
import com.bmw.gki.klib.api_current.impl.TypeUnitValueImpl;
import com.bmw.gki.klib.common.Einstellungen;
import com.bmw.gki.klib.config.GKISettings;
import com.bmw.gki.klib.data.apiparams.KeyDataHelper;
import com.bmw.gki.klib.data.apiparams.OrderbaseUpdateData;
import com.bmw.gki.klib.data.apitransformation.TypeErrorAdapter;
import com.bmw.gki.klib.data.ksd.bsi.BSIServicePaket;
import com.bmw.gki.klib.data.ksd.cbs.BOSVerknuepfung;
import com.bmw.gki.klib.data.ksd.cbs.SSIFormula;
import com.bmw.gki.klib.data.orderbase.BOSAWPosition;
import com.bmw.gki.klib.data.orderbase.BOSPosition;
import com.bmw.gki.klib.data.orderbase.SchluesseldatenE65;
import com.bmw.gki.klib.data.xsd.FlatRateUnit;
import com.bmw.gki.klib.external.cache.BOSAWNummerReader;
import com.bmw.gki.klib.external.cache.BOSVerknuepfungReader;
import com.bmw.gki.klib.external.cache.MModelReader;
import com.bmw.gki.klib.external.cache.SSIInformationReader;
import com.bmw.gki.klib.logic.GKILogic;
import com.bmw.gki.klib.util.GKIHelper;
import com.bmw.gki.klib.util.StatusMeasureReader;
import com.bmw.gki.klib.util.Utilities;
import com.bmw.gki.logging.GKILogManager;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.commons.logging.Log;

public class BOSVerarbeitungsLogik {
    private static Log log = GKILogManager.getInstance().getLogger(BOSVerarbeitungsLogik.class);
    private String saOptionCode = null;
    private Vector<SSIFormula> saOptionList = null;
    private boolean isSSInterpretation = false;
    private String ssiCountry;

    public List<BOSAWPosition> erzeugeBOSAWPositions(AuftragsbasisGrunddatenIF grundDaten, GKISettings settings, List<TypeErrorAdapter> warnings) throws GKIException {
        SchluesseldatenE65 keyData = (SchluesseldatenE65)grundDaten.getSchluesseldaten();
        String leittyp = grundDaten.getFgnrKreisInfo().getLeittyp();
        int baustand = grundDaten.getFgnrKreisInfo().getBaustand();
        try {
            this.checkBosAwPositionsExist(leittyp, baustand);
        }
        catch (KeineArbeitswerteException e) {
            GKILogic.addToWarningsListOnlyOnce(e, warnings);
        }
        ArrayList<BOSAWPosition> bosAwPositions = new ArrayList<BOSAWPosition>();
        BOSAWPosition bosAwStandard = this.createBosAwPositionStandardUmfang(grundDaten, leittyp, baustand);
        if (bosAwStandard != null) {
            bosAwPositions.add(bosAwStandard);
        }
        List<BOSAWPosition> bosAwPositionsFromAuftragsBasis = this.createBosAwPositionsFromAuftragsbasis(grundDaten, settings, warnings);
        bosAwPositions.addAll(bosAwPositionsFromAuftragsBasis);
        String regionCode = settings.getRegionCode();
        int engineType = grundDaten.getSchluesseldaten().getData().getVehicle().isSetEngine() ? grundDaten.getSchluesseldaten().getData().getVehicle().getEngine() : 0;
        String eSeries = grundDaten.getFgnrKreisInfo().getEngineeringSeries();
        String model = grundDaten.getFgnrKreisInfo().getModelBezeichnung();
        List<BOSAWPosition> childPositions = this.getChildPositions(bosAwPositions, leittyp, baustand, regionCode, keyData.getErstzulassung(), engineType, eSeries, model, warnings);
        this.initSelectionFlag(bosAwPositions, Einstellungen.getDefaultInstance().getAutomaticSelectRecommendedService(), grundDaten.isUebergabedurchsicht());
        bosAwPositions.addAll(childPositions);
        this.setVerbundFlag(bosAwPositions);
        if (log.isTraceEnabled()) {
            Iterator i = bosAwPositions.iterator();
            while (i.hasNext()) {
                log.trace(i.next());
            }
        }
        return bosAwPositions;
    }

    private BOSAWPosition createBosAwPositionStandardUmfang(AuftragsbasisGrunddatenIF grundDaten, String leittyp, int baustand) {
        if (!grundDaten.isUebergabedurchsicht()) {
            try {
                return BOSAWPosition.standardUmfang(leittyp, baustand, this.ssiCountry != null);
            }
            catch (GKIException ex) {
                // empty catch block
            }
        }
        return null;
    }

    private List<BOSAWPosition> createBosAwPositionsFromAuftragsbasis(AuftragsbasisGrunddatenIF grundDaten, GKISettings settings, List<TypeErrorAdapter> warnings) throws GKIException {
        SchluesseldatenE65 keyDataE65 = (SchluesseldatenE65)grundDaten.getSchluesseldaten();
        BSIServicePaket bsiServicePaket = grundDaten.getBSIServicePaket();
        int baustand = grundDaten.getFgnrKreisInfo().getBaustand();
        String leittyp = grundDaten.getFgnrKreisInfo().getLeittyp();
        Fahreigenschaft fahreigenschaft = null;
        BSIBerechnungsbasis berechnungsbasis = null;
        if (bsiServicePaket != null && bsiServicePaket.isAktiv() && (berechnungsbasis = bsiServicePaket.getBerechnungsbasis()) != null) {
            int min = berechnungsbasis.getMin();
            int max = berechnungsbasis.getMax();
            if (keyDataE65.getBOSDaten().isMilesWrittenKey()) {
                min = (int)Utilities.convertToMiles(min);
                max = (int)Utilities.convertToMiles(max);
            }
            fahreigenschaft = keyDataE65.ermittleFahreigenschaften(min, max, settings);
        }
        String regionCode = settings.getRegionCode();
        ArrayList<BOSAWPosition> bosAWPositions = new ArrayList<BOSAWPosition>();
        for (BOSPosition bosPosition : keyDataE65.getBOSPositionen()) {
            try {
                BOSAWPosition bosAWPosition = new BOSAWPosition(bosPosition, leittyp, baustand, this.ssiCountry != null);
                if (!bosAWPosition.bosAWNummerFound()) {
                    String message = "AW Position for the cbsId: " + (bosPosition != null ? bosPosition.getCbsId() : null) + ", the leadtype: " + leittyp + " and the baustand: " + baustand + " doesn't exist";
                    KeineArbeitswerteException kawException = new KeineArbeitswerteException(message);
                    GKILogic.addToWarningsListOnlyOnce(kawException, warnings);
                }
                Date keyUpdateDate = null;
                keyUpdateDate = keyDataE65.getLetzteAktualisierung() != null ? keyDataE65.getLetzteAktualisierung() : keyDataE65.getEinleseDatum();
                int shortTimeDrivingPerformance = keyDataE65.getBOSDaten().getShortTimeDrivingPerformance();
                bosAWPosition.setKennungEmpfehlung(regionCode, keyUpdateDate, shortTimeDrivingPerformance, fahreigenschaft, berechnungsbasis);
                if (grundDaten.isUebergabedurchsicht()) {
                    bosAWPosition.setFestSelektiert(true);
                }
                bosAWPositions.add(bosAWPosition);
            }
            catch (GKIException ex) {
                GKILogic.addToWarningsListOnlyOnce(ex, warnings);
                log.trace((Object)ex.getFormatedMessage());
            }
        }
        return bosAWPositions;
    }

    private List<BOSAWPosition> getChildPositions(List<BOSAWPosition> bosAwPositions, String leittyp, int baustand, String regionCode, Date erstZulassung, int engineType, String eSeries, String model, List<TypeErrorAdapter> warnings) throws GKIException {
        ArrayList<BOSAWPosition> result = new ArrayList<BOSAWPosition>();
        boolean MOTOROEL = true;
        if (bosAwPositions != null) {
            for (int i = bosAwPositions.size() - 1; i >= 0; --i) {
                BOSAWPosition parentPosition = bosAwPositions.get(i);
                List<BOSAWPosition> childPositions = this.getChildPositions(parentPosition, bosAwPositions, leittyp, baustand, regionCode, erstZulassung, engineType, warnings);
                try {
                    if (parentPosition.getBosNr().getBosNr() == 1 && parentPosition.getServiceZaehler() == 1) {
                        this.checkMModelEinfahrserviceAndRemoveMikrofilter(parentPosition, childPositions, eSeries, model);
                    }
                }
                catch (Exception e) {
                    log.info((Object)"Remove CBS ID: 119 - M-model failure: ", (Throwable)e);
                }
                result.addAll(childPositions);
            }
        }
        return result;
    }

    private void checkMModelEinfahrserviceAndRemoveMikrofilter(BOSAWPosition parentPosition, List<BOSAWPosition> childPositions, String eSeries, String model) {
        int MIKROFILTER = 119;
        if (MModelReader.isMModel(eSeries, model)) {
            Iterator<BOSAWPosition> iter = childPositions.iterator();
            while (iter.hasNext()) {
                BOSAWPosition element = iter.next();
                if (element.getBosNr().getBosNr() != 119) continue;
                log.info((Object)"M Modell - Motoroel service counter = 1 => remove Mikrofilter cbs id 119");
                iter.remove();
            }
        }
    }

    private List<BOSAWPosition> getChildPositions(BOSAWPosition bosAWPosition, List<BOSAWPosition> bosListe, String leittyp, int baustand, String region, Date erstzulassung, int engineType, List<TypeErrorAdapter> warnings) throws GKIException {
        ArrayList<BOSAWPosition> childPositions = new ArrayList<BOSAWPosition>();
        Vector<BOSVerknuepfung> verkuepfungen = BOSVerknuepfungReader.find(region, leittyp, bosAWPosition.getBosNr(), baustand);
        if (verkuepfungen != null) {
            Enumeration<BOSVerknuepfung> en = verkuepfungen.elements();
            while (en.hasMoreElements()) {
                SSIFormula ssiFormula;
                BOSVerknuepfung bosVerknuepfung = en.nextElement();
                String verknuepfungsTyp = bosVerknuepfung.getTyp();
                int ssi_psc_value = 0;
                int ssi_asc_value = 0;
                if (this.saOptionCode != null && (ssiFormula = this.getSSIRecord(bosVerknuepfung.getBosNrVon().getIdString(), bosVerknuepfung.getBosNrNach().getIdString(), engineType, bosVerknuepfung.getTyp(), this.ssiCountry)) != null) {
                    log.info((Object)("SSI Formel: " + ssiFormula.toString()));
                    ssi_psc_value = ssiFormula.getPSC();
                    ssi_asc_value = ssiFormula.getASC();
                    if (ssiFormula != null && (ssi_psc_value != 0 || ssi_asc_value != 0)) {
                        log.info((Object)"SSI: G\u00fcltige Formel konfiguriert ! isSSIInterpretation  = true");
                        this.isSSInterpretation = true;
                    }
                }
                boolean verknuepfung = false;
                if ("ASC".equals(verknuepfungsTyp)) {
                    if (bosAWPosition.getServiceZaehler() == bosVerknuepfung.getFaelligAb() + ssi_asc_value || bosAWPosition.getServiceZaehler() == 0) {
                        verknuepfung = true;
                    }
                } else if ("PSC".equals(verknuepfungsTyp)) {
                    int modValue = bosVerknuepfung.getFaelligAb() + bosVerknuepfung.getFaelligAb() * ssi_psc_value + ssi_asc_value;
                    if (modValue > 0 && bosAWPosition.getServiceZaehler() % modValue == 0) {
                        verknuepfung = true;
                    }
                    if (modValue <= 0) {
                        log.info((Object)("SSI: Hinweis PSC - Verkn\u00fcpfungstyp: ServiceZ\u00e4hler % 0 oder negative Zahl ! modVal: " + modValue + " falls SSI =>usedShortenedServiceIntervall =  false"));
                        this.isSSInterpretation = false;
                    }
                } else if ("APD".equals(verknuepfungsTyp)) {
                    int tage = 0;
                    try {
                        tage = this.ermittelnLagerzeitraum(erstzulassung);
                    }
                    catch (RegistrationDateException e) {
                        verknuepfung = true;
                        GKILogic.addToWarningsListOnlyOnce(e, warnings);
                    }
                    if (tage > bosVerknuepfung.getFaelligAb() && tage < bosVerknuepfung.getFaelligBis()) {
                        verknuepfung = true;
                    }
                }
                if (verknuepfung) {
                    BOSAWPosition childPosition = bosAWPosition.addChild(bosVerknuepfung.getBosNrNach(), leittyp, baustand, this.ssiCountry != null);
                    childPositions.add(childPosition);
                    continue;
                }
                if (bosAWPosition.isUebergabedurchsicht() || bosVerknuepfung.isDynamicPosition()) continue;
                BOSAWPosition tpos = new BOSAWPosition(new BOSPosition(bosVerknuepfung.getBosNrNach().getBosNr(), 0, 0, 0), leittyp, baustand, this.ssiCountry != null);
                int index = bosListe.indexOf(bosAWPosition);
                bosListe.add(index + 1, tpos);
            }
        }
        return childPositions;
    }

    private void initSelectionFlag(List<BOSAWPosition> bosAWPositions, boolean automaticSelectRecommendedService, boolean isFestselektiert) {
        if (bosAWPositions != null) {
            for (BOSAWPosition bosAWPosition : bosAWPositions) {
                Integer statusMeasure;
                BOSPosition bosPosition;
                switch (bosAWPosition.getBosZustand()) {
                    case 1: 
                    case 2: {
                        bosAWPosition.setSelectionFlag(Boolean.TRUE);
                        break;
                    }
                    default: {
                        bosAWPosition.setSelectionFlag(Boolean.FALSE);
                    }
                }
                if (automaticSelectRecommendedService && bosAWPosition.getKennungEmpfehlung() == '\u0001') {
                    bosAWPosition.setSelectionFlag(Boolean.TRUE);
                }
                if ((bosPosition = bosAWPosition.getBOSPosition()) == null || (statusMeasure = bosPosition.getStatusMeasure()) == null || !StatusMeasureReader.getInstance().hasFlag("statusReplacementValue", statusMeasure)) continue;
                bosAWPosition.setSelectionFlag(Boolean.FALSE);
                if (bosAWPosition.isFestSelektiert()) {
                    bosAWPosition.setFestSelektiert(false);
                }
                if (bosAWPosition.getKennungEmpfehlung() == '\u0000') continue;
                bosAWPosition.setKennungEmpfehlung('\u0000');
            }
        }
    }

    private int ermittelnLagerzeitraum(Date erstzulassungsdatum) throws RegistrationDateException {
        if (erstzulassungsdatum == null) {
            throw new RegistrationDateException("first registration data not set");
        }
        long value = new Date().getTime() - erstzulassungsdatum.getTime();
        value = (long)Math.ceil((double)value / 8.64E7);
        return (int)value;
    }

    public boolean pruefenSelektionsKriterien(List<BOSAWPosition> bosAWPositions, boolean wasSelected, BOSAWPosition selectedPosition) {
        if (bosAWPositions != null) {
            BOSAWPosition bosAW;
            int i;
            int rowCount = bosAWPositions.size();
            boolean verbundArbeit = false;
            Boolean itemSelected = Boolean.FALSE;
            Boolean tuevauSelected = Boolean.FALSE;
            for (i = 0; i < rowCount; ++i) {
                bosAW = bosAWPositions.get(i);
                if (bosAW.isFestSelektiert()) {
                    bosAW.setSelectionFlag(Boolean.TRUE);
                }
                if (bosAW.hasVerknuepfungsliste()) {
                    for (int xx = 0; xx < bosAW.getVerknuepfungsliste().size(); ++xx) {
                        BOSAWPosition connected = bosAW.getVerknuepfungsliste().elementAt(xx);
                        boolean found = false;
                        int j = 0;
                        while (j < rowCount && !found) {
                            String bosNr = bosAWPositions.get(j).getBosNr().getIdString();
                            if (bosNr.equals(connected.getBosNr().getIdString())) {
                                found = true;
                                continue;
                            }
                            ++j;
                        }
                        if (!found) continue;
                        BOSAWPosition childPos = bosAWPositions.get(j);
                        if (bosAW.getServiceZaehler() == 0) {
                            if (!bosAW.getSelectionFlag().booleanValue()) {
                                childPos.setSelectionFlag(Boolean.FALSE);
                            }
                            if (!childPos.getSelectionFlag().booleanValue()) continue;
                            childPos.setFestSelektiert(false);
                            continue;
                        }
                        if ((selectedPosition == null || !selectedPosition.equals(bosAW)) && selectedPosition != null) continue;
                        childPos.setSelectionFlag(bosAW.getSelectionFlag());
                    }
                }
                if (i == 0 || !bosAWPositions.get(i).getSelectionFlag().booleanValue()) continue;
                if (bosAW.isTuev() || bosAW.isAu()) {
                    tuevauSelected = Boolean.TRUE;
                    continue;
                }
                itemSelected = Boolean.TRUE;
            }
            if (bosAWPositions != null && bosAWPositions.size() > 0) {
                BOSAWPosition standard = bosAWPositions.get(0);
                if (!standard.isFestSelektiert()) {
                    if (!tuevauSelected.booleanValue()) {
                        standard.setSelectionFlag(itemSelected);
                    }
                    if (tuevauSelected.booleanValue() && itemSelected.booleanValue()) {
                        standard.setSelectionFlag(Boolean.TRUE);
                    }
                    if (tuevauSelected.booleanValue() && !itemSelected.booleanValue() && wasSelected) {
                        standard.setSelectionFlag(Boolean.FALSE);
                    }
                }
                wasSelected = bosAWPositions.get(0).getSelectionFlag();
            }
            for (i = 0; i < rowCount; ++i) {
                bosAW = bosAWPositions.get(i);
                if (bosAWPositions.get(i).getSelectionFlag().booleanValue()) {
                    if (verbundArbeit) {
                        bosAW.setVerbundFlag(true);
                        continue;
                    }
                    bosAW.setVerbundFlag(false);
                    verbundArbeit = true;
                    continue;
                }
                bosAW.setVerbundFlag(false);
            }
        }
        return wasSelected;
    }

    public void aktualisierenCBSWerte(String region, OrderbaseUpdateData data, Locale locale, List<TypeErrorAdapter> warnings) throws GKIException {
        String leittyp = data.getLeadtype();
        Date erstzulassung = data.getCreationdate();
        String baustand = data.getBuilddate();
        Vector<OrderBaseType.ServiceInformation.TimeLine.CbsList.ConditionBasedService> cbsList = data.getCbsList();
        char cbsVariante = ' ';
        Date keyUpdateDate = data.getKeyUpdateDate();
        int shortTimeDrivingPerformance = data.getShorttimeDrivingPerformance();
        int baustandValue = 0;
        if (baustand != null) {
            baustand = baustand.replaceAll("[-\\.]", "").substring(0, 6);
            baustandValue = Integer.parseInt(baustand);
        }
        if (cbsList != null && !cbsList.isEmpty()) {
            TypeMileage nextServiceDistance;
            Vector<BOSAWPosition> bosAWPositionen = this.erzeugeBOSAWPositionsUpdateOrderbase(region, erstzulassung, leittyp, baustandValue, cbsList, cbsVariante, keyUpdateDate, shortTimeDrivingPerformance, warnings);
            if (bosAWPositionen != null && !bosAWPositionen.isEmpty()) {
                BOSAWPosition bosAWPosition = bosAWPositionen.firstElement();
                Boolean selektion = bosAWPosition.getSelectionFlag();
                for (OrderBaseType.ServiceInformation.TimeLine.CbsList.ConditionBasedService cbs : cbsList) {
                    if (!cbs.isSelectionRequest()) continue;
                    bosAWPosition = this.findBosAWforCbs(cbs, bosAWPositionen);
                    if (bosAWPosition != null) {
                        bosAWPosition.setSelectionFlag(bosAWPosition.getSelectionFlag() != false ? Boolean.FALSE : Boolean.TRUE);
                    }
                    cbs.setSelectionRequest(false);
                }
                this.pruefenSelektionsKriterien(bosAWPositionen, selektion, bosAWPosition);
                for (OrderBaseType.ServiceInformation.TimeLine.CbsList.ConditionBasedService cbs : cbsList) {
                    bosAWPosition = this.findBosAWforCbs(cbs, bosAWPositionen);
                    if (bosAWPosition == null) continue;
                    cbs.setSelectionFlag(bosAWPosition.getSelectionFlag());
                    cbs.setAssociatedLabourOperation(bosAWPosition.getVerbundFlag());
                    if (bosAWPosition.bosAWNummerFound()) {
                        FlatRateUnit flateRateUnit = new FlatRateUnit(bosAWPosition);
                        TypeUnitValue typeUnitValue = this.getFlatRateQuantityUnitValue(flateRateUnit, locale);
                        OrderBaseType.ServiceInformation.TimeLine.CbsList.ConditionBasedService.FlatRateUnit flatType = flateRateUnit.create(locale);
                        flatType.setQuantity(typeUnitValue);
                        cbs.setFlatRateUnit(flatType);
                    }
                    cbs.setIsUnselectable(cbs.isSelectionFlag() && bosAWPosition.isFestSelektiert());
                }
            }
            if ((nextServiceDistance = data.getNextServiceDistance()) == null) {
                nextServiceDistance = new TypeMileageImpl();
                nextServiceDistance.setUnits("km");
                data.setNextServiceDistance(nextServiceDistance);
            }
            long nextRemainingDistance = Long.MAX_VALUE;
            long nextRemainingTime = Long.MAX_VALUE;
            for (OrderBaseType.ServiceInformation.TimeLine.CbsList.ConditionBasedService cbs : cbsList) {
                int forecasttime;
                int forecastDistance;
                if (cbs.isAssociatedLabourOperation()) continue;
                if (!cbs.isSelectionFlag()) {
                    if (cbs.isSetRemainingDistance() && cbs.getRemainingDistance().isSetIsNextDue() && cbs.getRemainingDistance().isIsNextDue() && cbs.getRemainingDistance().getValue().longValue() < nextRemainingDistance) {
                        nextRemainingDistance = cbs.getRemainingDistance().getValue().longValue();
                    }
                    if (!cbs.isSetRemainingTime() || !cbs.getRemainingTime().isSetIsNextDue() || !cbs.getRemainingTime().isIsNextDue() || cbs.getRemainingTime().getValue().longValue() >= nextRemainingTime) continue;
                    nextRemainingTime = cbs.getRemainingTime().getValue().longValue();
                    continue;
                }
                if (20 != Integer.parseInt(cbs.getIdentifier())) continue;
                if (cbs.isSetForecastRemainingDistance() && (forecastDistance = cbs.getForecastRemainingDistance().getValue().intValue() * 1000) > 0 && (long)forecastDistance < nextRemainingDistance) {
                    nextRemainingDistance = forecastDistance;
                }
                if (!cbs.isSetForecastRemainingTime() || (forecasttime = cbs.getForecastRemainingTime().getValue().intValue() * 30) <= 0 || (long)forecasttime >= nextRemainingTime) continue;
                nextRemainingTime = forecasttime;
            }
            if (nextRemainingDistance == Long.MAX_VALUE) {
                data.setNextServiceDistance(null);
            } else {
                nextServiceDistance.setValue(nextRemainingDistance);
                NumberFormat numberFormat = NumberFormat.getInstance(locale);
                String valueInDisplayFormat = numberFormat.format(new Float(nextRemainingDistance));
                nextServiceDistance.setValueInDisplayFormat(valueInDisplayFormat);
            }
            if (nextRemainingTime == Long.MAX_VALUE) {
                data.setNextServiceDate(null);
            } else {
                Calendar nextServiceDate = KeyDataHelper.retrieveCalendar(keyUpdateDate != null ? keyUpdateDate : new Date(), TimeZone.getDefault());
                nextServiceDate.add(5, (int)nextRemainingTime);
                data.setNextServiceDate(nextServiceDate);
            }
        }
    }

    private TypeUnitValue getFlatRateQuantityUnitValue(FlatRateUnit flatRateUnit, Locale locale) throws GKIException {
        BigDecimal quantity;
        TypeUnitValueImpl unitVal = new TypeUnitValueImpl();
        unitVal.setUnits(flatRateUnit.getQuantityUnits());
        unitVal.setValue(new BigDecimal(flatRateUnit.getQuantity()));
        String unitsInDisplayFormat = GKIHelper.getTableString("detailsichtDialog.detailsichtTableModel.awWert", locale);
        unitVal.setUnitsInDisplayFormat(unitsInDisplayFormat);
        if (flatRateUnit.getQuantity() != null && (quantity = new BigDecimal(flatRateUnit.getQuantity())) != null) {
            unitVal.setValueInDisplayFormat(GKIHelper.determineNumberFormatter(locale).format(quantity));
        }
        return unitVal;
    }

    private BOSAWPosition findBosAWforCbs(OrderBaseType.ServiceInformation.TimeLine.CbsList.ConditionBasedService cbs, Vector<BOSAWPosition> bosAWPositionen) {
        if (bosAWPositionen != null) {
            for (BOSAWPosition bosAWPosition : bosAWPositionen) {
                int bosNr = 0;
                if (cbs.getIdentifier() != null) {
                    bosNr = Integer.parseInt(cbs.getIdentifier());
                }
                if (bosAWPosition.getBosNr().getBosNr() != bosNr) continue;
                return bosAWPosition;
            }
        }
        return null;
    }

    private void setVerbundFlag(List<BOSAWPosition> bosAWPositions) {
        boolean verbundFlag = false;
        if (bosAWPositions != null) {
            for (BOSAWPosition pos : bosAWPositions) {
                if (!pos.getSelectionFlag().booleanValue()) continue;
                pos.setVerbundFlag(verbundFlag);
                verbundFlag = true;
            }
        }
    }

    private Vector<BOSAWPosition> erzeugeBOSAWPositionsUpdateOrderbase(String regionCode, Date erstZulassung, String leittyp, int baustand, Vector<OrderBaseType.ServiceInformation.TimeLine.CbsList.ConditionBasedService> cbsList, char cbsVariant, Date keyUpdateDate, int shortTimeDrivingPerformance, List<TypeErrorAdapter> warnings) throws GKIException {
        try {
            this.checkBosAwPositionsExist(leittyp, baustand);
        }
        catch (KeineArbeitswerteException e) {
            GKILogic.addToWarningsListOnlyOnce(e, warnings);
        }
        Vector<BOSAWPosition> bosAwPositions = new Vector<BOSAWPosition>();
        if (cbsList != null) {
            for (OrderBaseType.ServiceInformation.TimeLine.CbsList.ConditionBasedService conditionBasedService : cbsList) {
                BOSAWPosition bosAWPosition = new BOSAWPosition(conditionBasedService, leittyp, baustand, this.ssiCountry != null);
                if (!bosAWPosition.bosAWNummerFound()) {
                    String message = "AW Position for the cbsId: " + (conditionBasedService != null ? conditionBasedService.getIdentifier() : null) + ", the leadtype: " + leittyp + " and the baustand: " + baustand + " doesn't exist";
                    KeineArbeitswerteException kawException = new KeineArbeitswerteException(message);
                    GKILogic.addToWarningsListOnlyOnce(kawException, warnings);
                }
                if (conditionBasedService.isSelectionFlag()) {
                    bosAWPosition.setSelectionFlag(Boolean.TRUE);
                }
                bosAWPosition.setFestSelektiert(conditionBasedService.isSelectionFlag() && conditionBasedService.isIsUnselectable());
                if (conditionBasedService.isIsInBSIPackage()) {
                    bosAWPosition.setKennungEmpfehlung('\u0002');
                }
                bosAwPositions.add(bosAWPosition);
            }
        }
        return bosAwPositions;
    }

    private void checkBosAwPositionsExist(String leittyp, int baustand) throws KeineArbeitswerteException {
        if (!BOSAWNummerReader.exists(leittyp, baustand)) {
            String message = "AW Position for the leadtype: " + leittyp + " and the baustand: " + baustand + " doesn't exist";
            KeineArbeitswerteException kawException = new KeineArbeitswerteException(message);
            log.info((Object)(" error code: " + kawException.getErrorCode() + "message: " + message));
            throw kawException;
        }
    }

    private SSIFormula getSSIRecord(String cbsID, String linkedID, int engineType, String period, String country) {
        String strEngineType = null;
        switch (engineType) {
            case 4: {
                strEngineType = "B";
                break;
            }
            case 5: {
                strEngineType = "B";
                break;
            }
            case 6: {
                strEngineType = "D";
                break;
            }
            case 7: {
                strEngineType = "D";
                break;
            }
            default: {
                return null;
            }
        }
        for (int i = 0; i < this.saOptionList.size(); ++i) {
            SSIFormula curRec = this.saOptionList.elementAt(i);
            if (!curRec.getCbsId().equals(cbsID) || !curRec.getLinkedId().equals(linkedID) || !curRec.getEngineType().equals(strEngineType) && !curRec.getEngineType().equals("*") || !curRec.getPeriod().equals(period) || !curRec.isValidCountry(country)) continue;
            log.info((Object)("Found SSI formula for position " + cbsID + "|" + linkedID + "|" + strEngineType + "|" + period + " - ASC value=" + curRec.getASC() + ", PSC value=" + curRec.getPSC()));
            return curRec;
        }
        return null;
    }

    public void setSSICountry(String ssiCountry) {
        this.ssiCountry = ssiCountry;
    }

    public void setSAOptionCode(String saCode) {
        this.saOptionCode = saCode;
        this.saOptionList = SSIInformationReader.getSSIFormulas(this.saOptionCode);
    }

    public boolean isSSInterpretation() {
        return this.isSSInterpretation;
    }
}

