/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.logic;

import com.bmw.gki.ka.AnalyzeException;
import com.bmw.gki.ka.KeyAnalyzer;
import com.bmw.gki.ka.keydata.KeyDataTo;
import com.bmw.gki.ka.util.PreProdHolder;
import com.bmw.gki.ka.util.PreProdLogEntry;
import com.bmw.gki.klib.api.KeyDataBinIF;
import com.bmw.gki.klib.api.exception.AnalyserException;
import com.bmw.gki.klib.api.exception.NotSupportedKeyvariantException;
import com.bmw.gki.klib.api.exception.WrongVinFormatException;
import com.bmw.gki.klib.api_current.KeyDataAnalysedType;
import com.bmw.gki.klib.data.apiparams.KeyDataAnalysed;
import com.bmw.gki.klib.external.cache.KSDCache;
import com.bmw.gki.klib.util.Utilities;
import com.bmw.gki.logging.GKILogManager;
import java.io.File;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;

public class KeyAnalyserLogic {
    private static final Log log = GKILogManager.getInstance().getLogger(KeyAnalyserLogic.class);

    public String retieveVin(KeyDataBinIF bin) throws WrongVinFormatException, AnalyserException {
        return this.analyseKey(bin.getContent()).getVin();
    }

    public KeyDataAnalysedType analyseKey(KeyDataBinIF bin, Locale locale) throws AnalyserException, WrongVinFormatException {
        KeyDataTo keydata = this.analyseKey(bin.getContent());
        return new KeyDataAnalysed(keydata, bin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getKeyDataXML(byte[] content) {
        String keyDataXML = null;
        try {
            KeyDataTo keyDataTo = null;
            keyDataTo = this.analyseKey(content);
            keyDataXML = keyDataTo.getFieldRecord().toXml();
        }
        catch (AnalyserException e) {
        }
        catch (WrongVinFormatException wrongVinFormatException) {
        }
        finally {
            KeyAnalyserLogic.releasePreProd();
        }
        return keyDataXML;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] writeKeyValue(String uid, String value, byte[] keyToWrite) {
        byte[] newKey = (byte[])keyToWrite.clone();
        try {
            Class<?> analyserClass = KSDCache.getInstance().getKeyAnalyserClass();
            try {
                if (analyserClass == null) {
                    throw new InstantiationException("KeyAnalyzer class not loaded");
                }
                KeyAnalyzer keyAnalyzer = (KeyAnalyzer)analyserClass.newInstance();
                newKey = keyAnalyzer.writeKeyValue(uid, value, keyToWrite);
            }
            catch (InstantiationException e) {
                String message = "KeyAnalyserLogic InstantiationException of KeyAnalyser Class";
                AnalyserException ae = new AnalyserException(message, e);
                log.info((Object)("exception code: " + ae.getErrorCode() + " message: " + message));
                throw ae;
            }
            catch (IllegalAccessException e) {
                String message = "KeyAnalyserLogic IllegalAccessException of KeyAnalyser Class";
                AnalyserException ae = new AnalyserException(message, e);
                log.info((Object)("exception code: " + ae.getErrorCode() + " message: " + message));
                throw ae;
            }
            catch (AnalyzeException e) {
                if (e.getErrorCode() == 1) {
                    NotSupportedKeyvariantException ne = new NotSupportedKeyvariantException(e);
                    log.fatal((Object)("code: " + ne.getErrorCode() + " : no rule found in keyformat configuration for this key"));
                    throw ne;
                }
                AnalyserException ae = new AnalyserException(e);
                log.fatal((Object)("code: " + ae.getErrorCode() + " : error processing key format file"));
                throw ae;
            }
        }
        catch (AnalyserException e) {
        }
        finally {
            KeyAnalyserLogic.releasePreProd();
        }
        return newKey;
    }

    private KeyDataTo analyseKey(byte[] content) throws AnalyserException, WrongVinFormatException {
        Class<?> analyserClass = KSDCache.getInstance().getKeyAnalyserClass();
        try {
            if (analyserClass == null) {
                throw new InstantiationException("KeyAnalyser class not loaded");
            }
            KeyAnalyzer keyAnalyzer = (KeyAnalyzer)analyserClass.newInstance();
            KeyDataTo keydata = keyAnalyzer.analyze(content);
            return keydata;
        }
        catch (InstantiationException e) {
            String message = "KeyAnalyserLogic InstantiationException of KeyAnalyser Class";
            AnalyserException ae = new AnalyserException(message, e);
            log.info((Object)("exception code: " + ae.getErrorCode() + " message: " + message));
            throw ae;
        }
        catch (IllegalAccessException e) {
            String message = "KeyAnalyserLogic IllegalAccessException of KeyAnalyser Class";
            AnalyserException ae = new AnalyserException(message, e);
            log.info((Object)("exception code: " + ae.getErrorCode() + " message: " + message));
            throw ae;
        }
        catch (AnalyzeException e) {
            if (e.getErrorCode() == 1) {
                NotSupportedKeyvariantException ne = new NotSupportedKeyvariantException(e);
                log.fatal((Object)("code: " + ne.getErrorCode() + " : no rule found in keyformat configuration for this key"));
                throw ne;
            }
            AnalyserException ae = new AnalyserException(e);
            log.fatal((Object)("code: " + ae.getErrorCode() + " : error processing key format file"));
            throw ae;
        }
    }

    public static void initPreProd(byte[] content) {
        log.debug((Object)"***PreProdHolder init***");
        PreProdHolder.reset();
        if (KSDCache.getInstance().isPreProduction()) {
            PreProdHolder.setBinFile(content);
        }
    }

    public static void releasePreProd() {
        log.trace((Object)"****release Pre Prod*******");
        if (KSDCache.getInstance().isPreProduction()) {
            String binFileName = null;
            List<PreProdLogEntry> entries = PreProdHolder.getLogEntries();
            if (entries != null && entries.size() > 0) {
                try {
                    if (PreProdHolder.getBinFile() != null) {
                        if (!new File(KSDCache.getInstance().getPreProductionErrorPath(), "nobin.txt").exists()) {
                            binFileName = Utilities.saveLogBinFile(PreProdHolder.getBinFile(), KSDCache.getInstance().getPreProductionErrorPath(), "binData");
                            log.trace((Object)("bin file Name is: " + binFileName));
                        } else {
                            log.info((Object)"Save bin file disabled: - please remove nobin.txt from error dir (preprod-path)");
                        }
                    }
                    if (!new File(KSDCache.getInstance().getPreProductionErrorPath(), "nolog.txt").exists()) {
                        Utilities.writeLogFile(binFileName, PreProdHolder.getAllFormattedLogEntries(), KSDCache.getInstance().getPreProductionErrorPath());
                    } else {
                        log.info((Object)"Save log file disabled: - please remove nolog.txt from error dir (preprod-path)");
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Can't release Pre prod values", (Throwable)e);
                }
            }
        }
    }
}

