/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.logic;

import com.bmw.gki.ka.exception.GKIException;
import com.bmw.gki.klib.api.BSIBerechnungsbasis;
import com.bmw.gki.klib.api.exception.BSIParameterException;
import com.bmw.gki.klib.config.GKISettings;
import com.bmw.gki.klib.data.apitransformation.TypeErrorAdapter;
import com.bmw.gki.klib.data.ksd.bsi.BSIDatensatzfehlerhaftException;
import com.bmw.gki.klib.data.ksd.bsi.BSIServicePaket;
import com.bmw.gki.klib.external.KSDDataRetrieverFactory;
import com.bmw.gki.klib.external.KSDDataRetrieverIF;
import java.util.List;
import java.util.Locale;

public class ServicePackageLogic {
    public static List<BSIServicePaket> retrieveServicePackage(String vin, Locale locale, boolean isMiles, List<TypeErrorAdapter> warnings, float totalDistance) throws GKIException {
        if (vin == null || vin.trim().length() == 0) {
            String message = "ServicePackageLogic vin  not set";
            throw new BSIParameterException(message);
        }
        if (locale == null) {
            String message = "ServicePackageLogic locale not set";
            throw new BSIParameterException(message);
        }
        if (warnings == null) {
            String message = "ServicePackageLogic warning list is null";
            throw new BSIParameterException(message);
        }
        KSDDataRetrieverIF retriever = KSDDataRetrieverFactory.getKSDDataRetriever(new GKISettings(locale, isMiles));
        List<BSIServicePaket> servicePackages = retriever.retrieveServicePackage(vin, locale, totalDistance);
        ServicePackageLogic.addCalculationBaseToBasicPackages(warnings, servicePackages, retriever);
        return servicePackages;
    }

    public static void addCalculationBaseToBasicPackages(List<TypeErrorAdapter> warnings, List<BSIServicePaket> si, KSDDataRetrieverIF retriever) {
        if (si != null) {
            for (BSIServicePaket pack : si) {
                try {
                    String contractType = pack.getVertragsTyp();
                    if (contractType != null) {
                        contractType = contractType.trim();
                    }
                    BSIBerechnungsbasis calc = retriever.retrieveSICalculation(contractType);
                    pack.setBerechnungsbasis(calc);
                }
                catch (BSIDatensatzfehlerhaftException e) {
                    warnings.add(new TypeErrorAdapter(e));
                }
            }
        }
    }
}

