/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.util;

import com.bmw.gki.ka.exception.GKIException;
import com.bmw.gki.klib.data.apitransformation.TypeErrorAdapter;
import com.bmw.gki.klib.util.Translator;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.commons.beanutils.BeanUtils;

public class GKIHelper {
    public static Locale createLocale(String localeString) {
        StringTokenizer localeTokens = new StringTokenizer(localeString, "-_ ");
        String language = localeTokens.nextToken();
        String country = language.toUpperCase();
        if (localeTokens.hasMoreTokens()) {
            country = localeTokens.nextToken();
        }
        return new Locale(language, country);
    }

    public static String getFormattedDateAsString(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        return formatter.format(date);
    }

    public static String getTableString(String lastKey, Locale locale) throws GKIException {
        Translator translator = Translator.getInstance();
        return translator.getString(lastKey, locale);
    }

    public static NumberFormat determineNumberFormatter(Locale locale) {
        NumberFormat numberFormat = NumberFormat.getInstance(locale);
        return numberFormat;
    }

    public static List<TypeErrorAdapter> toTypeErrorAdapterList(Collection<?> c) {
        ArrayList<TypeErrorAdapter> list = new ArrayList<TypeErrorAdapter>();
        for (Object o : c) {
            TypeErrorAdapter typeErrorAdapter = GKIHelper.toTypeErrorAdapter(o);
            if (typeErrorAdapter == null) continue;
            list.add(typeErrorAdapter);
        }
        return list;
    }

    public static TypeErrorAdapter toTypeErrorAdapter(Object o) {
        if (o instanceof TypeErrorAdapter) {
            return (TypeErrorAdapter)o;
        }
        try {
            TypeErrorAdapter typeErrorAdapter = new TypeErrorAdapter();
            BeanUtils.copyProperties((Object)typeErrorAdapter, (Object)o);
            return typeErrorAdapter;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

