/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.util;

import com.bmw.gki.klib.api.exception.KSDAccessException;
import com.bmw.gki.klib.common.LanguageSelection;
import com.bmw.gki.klib.external.cache.KSDCache;
import com.bmw.gki.logging.GKILogManager;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;

public abstract class ResourceLoader {
    protected final Log logger = GKILogManager.getInstance().getLogger(this.getClass());
    private final HashMap<Locale, ResourceBundle> bundles = new HashMap();

    protected ResourceBundle getResourceBundle(String bundleName, Locale locale) throws MissingResourceException {
        ResourceBundle bundle = this.bundles.get(locale);
        Locale validLocale = locale;
        if (bundle == null) {
            validLocale = LanguageSelection.getInstance().getValidLocale(new Locale(locale.getLanguage()));
            bundle = this.bundles.get(validLocale);
        }
        if (bundle != null) {
            return bundle;
        }
        this.logger.info((Object)"Bundle not exists in bundle HashMap");
        this.loadResourceBundleFromGKIOnDemand(bundleName, validLocale);
        bundle = this.bundles.get(validLocale);
        if (bundle != null) {
            return bundle;
        }
        String message = "resource bundle - unsupported locale:" + locale.getDisplayName();
        this.logger.warn((Object)message);
        throw new MissingResourceException(message, this.getClass().getName(), null);
    }

    protected void loadResourceBundlesFromKSD(String bundleName, String path, Locale[] supportedLocales) {
        this.logger.info((Object)"------------------------------------------------------------------");
        this.logger.info((Object)("loadResourceBundlesFromKSD('" + bundleName + "', '" + path + "')"));
        this.logger.info((Object)"------------------------------------------------------------------");
        try {
            ClassLoader propertyLoader = this.getClassLoader(path);
            for (int i = 0; i < supportedLocales.length; ++i) {
                Locale locale = supportedLocales[i];
                try {
                    ResourceBundle bundle = ResourceBundle.getBundle(bundleName, locale, propertyLoader);
                    if (bundle == null) continue;
                    this.bundles.put(locale, bundle);
                    continue;
                }
                catch (RuntimeException e) {
                    this.logger.debug((Object)("Exception in class " + this.getClass().getName() + ", try to read bundle from KSD: " + bundleName + " locale: " + locale + ", exception: " + e.getMessage()));
                }
            }
        }
        catch (KSDAccessException e) {
            this.logger.info((Object)"Exception message resource does not exist on KSD");
        }
    }

    private void loadResourceBundleFromGKIOnDemand(String bundleName, Locale locale) {
        this.logger.info((Object)"------------------------------------------------------------------");
        this.logger.info((Object)("loadResourceBundleFromGKIOnDemand('" + bundleName + "', '" + locale + "')"));
        this.logger.info((Object)"------------------------------------------------------------------");
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(bundleName, locale);
            if (bundle != null) {
                this.bundles.put(locale, bundle);
            }
        }
        catch (RuntimeException e1) {
            this.logger.info((Object)("Exception in class " + this.getClass().getName() + ", try to read bundle from GKI: " + bundleName + " locale: " + locale + " exception: " + e1.getMessage()));
        }
    }

    private ClassLoader getClassLoader(String path) throws KSDAccessException {
        File file = new File(path);
        if (!file.exists()) {
            String message = "Exception Messages resources not found on KSD path: " + path;
            KSDAccessException ex = new KSDAccessException(message);
            this.logger.info((Object)message);
            throw ex;
        }
        URL classPath = null;
        try {
            classPath = file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            String message = "Exception Messages MalformedURLException path: " + path;
            KSDAccessException ex = new KSDAccessException(message);
            this.logger.info((Object)message);
            throw ex;
        }
        return new KSDCache.SwitchClassLoader(new URL[]{classPath}, this.getClass().getClassLoader());
    }
}

