/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.util;

import java.util.StringTokenizer;

public class StringHelper {
    protected StringHelper() {
    }

    public static String pack(String str) {
        if (str == null) {
            return null;
        }
        str = StringHelper.trim(str);
        boolean fOneSpaceAdded = false;
        StringBuffer sb = new StringBuffer();
        int max = str.length();
        for (int i = 0; i < max; ++i) {
            if (Character.isSpaceChar(str.charAt(i))) {
                if (fOneSpaceAdded) continue;
                fOneSpaceAdded = true;
            } else {
                fOneSpaceAdded = false;
            }
            sb.append(str.charAt(i));
        }
        return sb.toString();
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static String trimLeft(String str) {
        if (str == null) {
            return null;
        }
        int pos = str.length();
        int max = str.length();
        for (int i = 0; i < max; ++i) {
            if (Character.isSpaceChar(str.charAt(i))) continue;
            pos = i;
            break;
        }
        return str.substring(pos);
    }

    public static String trimRight(String str) {
        if (str == null) {
            return null;
        }
        int pos = 0;
        for (int i = str.length() - 1; i > 0; --i) {
            if (Character.isSpaceChar(str.charAt(i))) continue;
            pos = i + 1;
            break;
        }
        return str.substring(0, pos);
    }

    protected static String fill(String str, char fillChar, int length, boolean fillLeft) {
        int len;
        int n = len = str == null ? 0 : str.length();
        if (len >= length) {
            return str;
        }
        StringBuffer sb = new StringBuffer(length);
        if (str != null) {
            sb.append(str);
        }
        int max = length - len;
        if (fillLeft) {
            for (int i = 0; i < max; ++i) {
                sb.insert(0, fillChar);
            }
        } else {
            for (int i = 0; i < max; ++i) {
                sb.append(fillChar);
            }
        }
        return sb.toString();
    }

    public static String fillLeft(String str, char fillChar, int length) {
        return StringHelper.fill(str, fillChar, length, true);
    }

    public static String fillRight(String str, char fillChar, int length) {
        return StringHelper.fill(str, fillChar, length, false);
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isTrimEmpty(String str) {
        return StringHelper.isEmpty(StringHelper.trim(str));
    }

    public static String toFirstUpperCase(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        StringBuffer buf = new StringBuffer(str.length());
        buf.append(Character.toUpperCase(str.charAt(0)));
        buf.append(str.toLowerCase().substring(1));
        return buf.toString();
    }

    public static boolean isUpperCase(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        return str.equals(str.toUpperCase());
    }

    public static boolean isLowerCase(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        return str.equals(str.toLowerCase());
    }

    public static String[] toArray(String str, String delimiters) {
        if (StringHelper.isTrimEmpty(str)) {
            return new String[0];
        }
        StringTokenizer toks = new StringTokenizer(str, delimiters);
        int num = toks.countTokens();
        String[] arStr = new String[num];
        for (int i = 0; i < num; ++i) {
            arStr[i] = toks.nextToken();
        }
        return arStr;
    }

    public static String removeChar(String strIn, String stopChars) {
        String ret = null;
        if (strIn != null) {
            ret = "";
            StringTokenizer tok = new StringTokenizer(strIn, stopChars);
            while (tok.hasMoreTokens()) {
                ret = ret + tok.nextToken();
            }
        }
        return ret;
    }

    public static String toUnicode(byte[] buf, boolean bigEndian) throws IllegalArgumentException {
        int bufLen = buf.length;
        if (bufLen % 2 != 0) {
            throw new IllegalArgumentException("The length of byte[] must be even.");
        }
        char[] arChar = new char[bufLen / 2];
        if (bigEndian) {
            int i = 0;
            int j = 0;
            while (i < bufLen) {
                int by1 = (0xFF & buf[i]) << 8;
                int by2 = 0xFF & buf[i + 1];
                arChar[j] = (char)(by1 + by2);
                i += 2;
                ++j;
            }
        } else {
            int i = 0;
            int j = 0;
            while (i < bufLen) {
                int by1 = 0xFF & buf[i];
                int by2 = (0xFF & buf[i + 1]) << 8;
                arChar[j] = (char)(by1 + by2);
                i += 2;
                ++j;
            }
        }
        return new String(arChar);
    }
}

