/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.util;

import com.bmw.gki.ka.exception.GKIException;
import com.bmw.gki.klib.common.Einstellungen;
import com.bmw.gki.klib.common.LanguageSelection;
import com.bmw.gki.klib.util.ResourceLoader;
import com.bmw.gki.logging.GKILogManager;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;

public class Translator
extends ResourceLoader {
    private static Log log = GKILogManager.getInstance().getLogger(Translator.class);
    public static final String RESOURCE_FILE = "gki_translator";
    private static Translator instance;
    private Locale locale;

    private Translator() {
    }

    private Translator(Locale locale) {
        this.locale = locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Translator getInstance() {
        Class<Translator> clazz = Translator.class;
        synchronized (Translator.class) {
            if (instance == null) {
                instance = new Translator();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static Translator getInstance(Locale locale) throws GKIException {
        Locale validLocale = locale;
        if (!Einstellungen.isSupportedLocale(locale) && (validLocale = LanguageSelection.getInstance().getValidLocale(new Locale(locale.getLanguage()))) == null) {
            throw new GKIException("translator.localeNichtUnterstuetzt");
        }
        return new Translator(validLocale);
    }

    public String getString(String key) {
        if (this.locale != null) {
            return this.getString(key, this.locale);
        }
        return this.getString(key, Locale.getDefault());
    }

    public String getString(String key, Locale locale) {
        try {
            String result;
            ResourceBundle bundle = Translator.getInstance().getResourceBundle(RESOURCE_FILE, locale);
            if (bundle == null) {
                Locale validLocale = LanguageSelection.getInstance().getValidLocale(new Locale(locale.getLanguage()));
                bundle = Translator.getInstance().getResourceBundle(RESOURCE_FILE, validLocale);
            }
            if ((result = bundle.getString(key)) != null) {
                return result;
            }
        }
        catch (MissingResourceException e) {
            log.trace((Object)e.getMessage());
        }
        log.trace((Object)("no Tanslation for " + key));
        int pos = key.lastIndexOf(".");
        if (pos > 0) {
            return key.substring(pos);
        }
        return key;
    }

    public String getString(String key, String[] placeholder) {
        String text = this.getString(key);
        return MessageFormat.format(text, placeholder);
    }

    public static void loadMessagesFromKSD(String path, Locale[] supportedLocales) {
        Translator.getInstance().loadResourceBundlesFromKSD(RESOURCE_FILE, path, supportedLocales);
    }

    public static void main(String[] args) {
        try {
            Translator translator = Translator.getInstance(new Locale("de", "US"));
            System.out.println(translator.getString("this") + " " + translator.getString("is") + " " + translator.getString("a") + " " + translator.getString("test"));
            translator = Translator.getInstance(new Locale("fr", "FR"));
            System.out.println(translator.getString("this") + " " + translator.getString("is") + " " + translator.getString("a") + " " + translator.getString("test"));
            translator = Translator.getInstance(Locale.US);
            System.out.println(translator.getString("this") + " " + translator.getString("is") + " " + translator.getString("a") + " " + translator.getString("test"));
            if (Einstellungen.isSupportedLocale(Locale.ENGLISH)) {
                translator = Translator.getInstance(Locale.ENGLISH);
                System.out.println(translator.getString("this") + " " + translator.getString("is") + " " + translator.getString("a") + " " + translator.getString("test"));
            } else {
                System.out.println(Locale.ENGLISH.toString() + " is no supported Locale!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getValue(String key) {
        String result = this.getString(key);
        if (result.length() > 0) {
            return result;
        }
        return null;
    }

    public static void reset() {
        instance = null;
    }
}

