/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.util;

import com.bmw.gki.ka.exception.GKIException;
import com.bmw.gki.klib.api.exception.CountryCodeInvalidException;
import com.bmw.gki.klib.api.exception.ServicePartnerIDInvalidException;
import com.bmw.gki.klib.api.exception.SystemException;
import com.bmw.gki.klib.api.exception.XMLBearbeitungsException;
import com.bmw.gki.klib.common.Einstellungen;
import com.bmw.gki.klib.data.ServicePartnerID;
import com.bmw.gki.klib.util.AppendFileStream;
import com.bmw.gki.logging.GKILogManager;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.net.URL;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.CRC32;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class Utilities {
    private static final Log log = GKILogManager.getInstance().getLogger(Utilities.class);
    public static final String CLASS_NAME = "Utilities";
    public static final String LINE_COMMENT = "#";
    public static final int HELP_CONTEXT = 1;
    public static final int HELP_QUIT = 2;
    public static final int HELP_INDEX = 3;
    public static final int HELP_CONTENTS = 3;
    public static final int HELP_HELPONHELP = 4;
    public static final int HELP_SETINDEX = 5;
    public static final int HELP_SETCONTENTS = 5;
    public static final int HELP_CONTEXTPOPUP = 8;
    public static final int HELP_FORCEFILE = 9;
    public static final int HELP_KEY = 257;
    public static final int HELP_COMMAND = 258;
    public static final int HELP_PARTIALKEY = 261;
    public static final int HELP_MULTIKEY = 513;
    public static final int HELP_SETWINPOS = 515;
    public static final int HELP_FINDER = 11;
    public static final int HELP_EINSTELLUNGEN = 323;
    public static final int HELP_EINFUEHRUNG = 31;
    public static final int HELP_SCHLUESSELDATEN = 331;
    public static final int HELP_MOBILER_SERVICE = 348;
    public static final int HELP_DYNAMISCHER_ZEITSTRAHL = 337;
    public static final int HELP_ZENTRALE_REPARATURHISTORIE = 341;
    public static final int HELP_DETAILSICHT = 345;
    public static final int HELP_INDIVIDUALDATEN = 346;
    public static final int HELP_NACHRUESTUNGEN = 347;
    public static final int HELP_STEUERGERAETE = 349;
    public static final int HELP_ERMITTELN_OFFENER_TAS = 351;
    public static final int HELP_LEITTYP_BAUSTAND = 332;
    public static final int HELP_SERVICE_CALLS = 3601;
    public static final int HELP_DETAILANSICHT_SERVICE_CALL = 444;
    public static final int KM_10 = 0;
    public static final int KM_100 = 1;
    public static final int KM_1000 = 2;
    public static final int KM_10000 = 3;
    private static SimpleDateFormat dateTimeFormatter = new SimpleDateFormat("yyyyMMdd_HHmm");
    private static SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyyMMdd");

    public static String getDateString(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy");
        if (date == null) {
            return null;
        }
        return formatter.format(date);
    }

    public static String getDateToXSDDate(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        if (date == null) {
            return null;
        }
        return formatter.format(date);
    }

    public static String getDateToXSDDateTime(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        if (date == null) {
            return null;
        }
        return formatter.format(date);
    }

    public static String getDateShortString(Date date, Locale locale) {
        DateFormat dateFormat = DateFormat.getDateInstance(3, locale);
        if (date == null) {
            return null;
        }
        return dateFormat.format(date);
    }

    public static Date getDateFromShortString(String strDate, Locale locale) throws ParseException {
        DateFormat dateFormat = DateFormat.getDateInstance(3, locale);
        dateFormat.setLenient(false);
        return dateFormat.parse(strDate);
    }

    public static String getBaustandToXSDgYearMonth(int baustand) {
        String strBaustand = new Integer(baustand).toString();
        if (strBaustand.length() >= 6) {
            String jahr = strBaustand.substring(0, 4);
            String monat = strBaustand.substring(4);
            strBaustand = jahr + "-" + monat;
        } else {
            log.debug((Object)("getBaustandToXSDgYearMonth:strBaustand (" + strBaustand + "), format ung\u00fcltig:: generiere strBaustand(0000-00)"));
            strBaustand = "0000-00";
        }
        return strBaustand;
    }

    public static XMLGregorianCalendar getBaustandToXMLGregorianCalendar(int baustand) {
        DatatypeFactory df = null;
        try {
            df = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            log.error((Object)("getBaustandToXMLGregorianCalendar:Exception(" + e + ")"));
        }
        String strJahr = "0000";
        String strMonat = "00";
        String strBaustand = new Integer(baustand).toString();
        if (strBaustand.length() >= 6) {
            strJahr = strBaustand.substring(0, 4);
            strMonat = strBaustand.substring(4, 6);
        } else {
            log.debug((Object)("getBaustandToXSDgYearMonth:strBaustand (" + strBaustand + "), format ung\u00fcltig:: generiere strBaustand(0002-12) (default start date from XMLGregorianCalendar)"));
        }
        GregorianCalendar date = new GregorianCalendar(Integer.parseInt(strJahr), Integer.parseInt(strMonat), 0);
        XMLGregorianCalendar xmlDate = df.newXMLGregorianCalendar(date);
        return xmlDate;
    }

    public static Date getXSDStringToDate(String datum) {
        Date date = null;
        SimpleDateFormat d = new SimpleDateFormat("yyyy-MM-dd");
        try {
            date = d.parse(datum);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    public static Locale getXSDLanguageToLocale(String xsdLanguage) {
        Locale locale = null;
        try {
            String sprache = xsdLanguage.substring(0, 2);
            String land = "";
            if (xsdLanguage.length() >= 5) {
                land = xsdLanguage.substring(3, 5);
            }
            locale = new Locale(sprache, land);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return locale;
    }

    public static String getLocaleToXSDLanguage(Locale locale) {
        if (locale.getCountry() != null && locale.getCountry().length() > 0) {
            return locale.getLanguage().concat("-").concat(locale.getCountry());
        }
        return locale.getLanguage();
    }

    public static Date getXSDStringBaustandToDate(String datum) {
        Date date = null;
        SimpleDateFormat d = new SimpleDateFormat("yyyy-MM");
        try {
            date = d.parse(datum);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    public static int getXSDStringBaustandToInt(String datum) throws GKIException {
        int baustand = 0;
        try {
            StringBuffer buff = new StringBuffer();
            int iPos = datum.indexOf("-");
            if (iPos > 0) {
                buff.append(datum.substring(0, iPos));
                buff.append(datum.substring(iPos + 1));
                baustand = Integer.parseInt(buff.toString());
            }
        }
        catch (Exception e) {
            log.error((Object)("getXSDStringBaustandToInt:Exception(" + e + ")"));
            throw new SystemException("Utilities.getXSDStringBaustandToInt:Unerwartete Exception", e);
        }
        return baustand;
    }

    public static Date getXSDDateTimeStringToDate(String datum) {
        Date date = null;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        try {
            date = formatter.parse(datum);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    public static String getTimeString(Date time) {
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy HH:mm");
        if (time == null) {
            return null;
        }
        return formatter.format(time);
    }

    public static String toString(int number, int length) {
        return Utilities.toString(number, length, ' ');
    }

    public static String toString(int number, int length, char fillChar) {
        String nStr = Integer.toString(number);
        while (nStr.length() < length) {
            nStr = fillChar + nStr;
        }
        return nStr;
    }

    public static String toString(long number, int length) {
        return Utilities.toString(number, length, ' ');
    }

    public static String toString(long number, int length, char fillChar) {
        String nStr = Long.toString(number);
        while (nStr.length() < length) {
            nStr = fillChar + nStr;
        }
        return nStr;
    }

    public static String rpad(String string, int length) {
        if (string.length() > length) {
            return string.substring(0, length);
        }
        while (string.length() < length) {
            string = string + " ";
        }
        return string;
    }

    public static boolean toBoolean(String name) {
        return name != null && !name.trim().equalsIgnoreCase("false") && !name.trim().equals("0");
    }

    public static int toInt(String strWithDecimalNumber) {
        if (strWithDecimalNumber == null || strWithDecimalNumber.equals("")) {
            return 0;
        }
        try {
            double doubleValue = Double.parseDouble(strWithDecimalNumber);
            return (int)Math.round(doubleValue);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static int convertToKm(int miles) {
        return Math.round((float)miles * 1.6093f);
    }

    public static float convertToKm(float miles) {
        return miles * 1.6093f;
    }

    public static double convertToMiles(double kilometres) {
        return kilometres / (double)1.6093f;
    }

    public static double convertToUSGallons(double liters) {
        return liters * 0.264179853;
    }

    public static double convertToUKGallons(double liters) {
        return liters * 0.219969248;
    }

    public static double convertToFahrenheit(double celsius) {
        return celsius * 9.0 / 5.0 + 32.0;
    }

    public static double roundDistance(int einheitAbstand, double distance) {
        int factor = 1;
        switch (einheitAbstand) {
            case 0: {
                factor = 10;
                break;
            }
            case 1: {
                factor = 100;
                break;
            }
            case 2: {
                factor = 1000;
                break;
            }
            case 3: {
                factor = 10000;
                break;
            }
        }
        double result = distance;
        result /= (double)factor;
        result = Math.round(result);
        return result *= (double)factor;
    }

    public static String formatFgnr(String fgnr) {
        return fgnr.substring(0, 3) + " " + fgnr.substring(3, 7) + " " + fgnr.substring(7, 10) + " " + fgnr.substring(10);
    }

    public static String getNotAvailableString() {
        return "***************";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String source, String target) throws IOException {
        int LENGTH = 1000;
        BufferedReader in = null;
        BufferedWriter out = null;
        try {
            int countBytes;
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(source), "ISO-8859-1"));
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(target), "ISO-8859-1"));
            char[] buffer = new char[LENGTH];
            while ((countBytes = in.read(buffer, 0, LENGTH)) != -1) {
                out.write(buffer, 0, countBytes);
            }
            out.flush();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static String nvl(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public static Locale getLocaleForSprache(String sprache) {
        Locale[] locales = Einstellungen.getSupportedLocales();
        String localeString = sprache.trim();
        if (localeString.length() < 5) {
            for (int i = locales.length - 1; i >= 0; --i) {
                if (!locales[i].getLanguage().equals(localeString) || locales[i].equals(Locale.US)) continue;
                return locales[i];
            }
        } else {
            for (int i = locales.length - 1; i >= 0; --i) {
                if (!locales[i].toString().equals(localeString)) continue;
                return locales[i];
            }
        }
        return null;
    }

    public static Date getStringToDate(String datumeingabe, Locale neueLocale) throws GKIException {
        Date rueckgabe = null;
        DateFormat dateFormat = DateFormat.getDateInstance(2, neueLocale);
        try {
            rueckgabe = dateFormat.parse(datumeingabe);
        }
        catch (Exception e) {
            throw new GKIException("allgemein.datum.ungueltig" + datumeingabe);
        }
        return rueckgabe;
    }

    public static String getDateString(Date date, Locale neueLocale) {
        String rueckgabe = null;
        DateFormat dateFormat = DateFormat.getDateInstance(2, neueLocale);
        if (date != null) {
            rueckgabe = dateFormat.format(date);
        }
        return rueckgabe;
    }

    public static String getDateStringLong(Date date, Locale neueLocale) {
        String rueckgabe = null;
        DateFormat dateFormat = DateFormat.getDateInstance(2, neueLocale);
        DateFormat timeFormat = DateFormat.getTimeInstance(3, neueLocale);
        if (date != null) {
            rueckgabe = dateFormat.format(date) + " " + timeFormat.format(date);
        }
        return rueckgabe;
    }

    public static String getBOSNummerAsString(int bosNr) {
        String idString = new Integer(bosNr).toString();
        while (idString.length() < 5) {
            idString = "0" + idString;
        }
        return idString;
    }

    public static Element createXMLNode(Document doc, String elementName, String value, Hashtable<String, ?> attributes) throws GKIException {
        Element element = null;
        try {
            if (elementName != null && elementName != null) {
                element = doc.createElement(elementName);
                if (value != null) {
                    Text text = doc.createTextNode(value);
                    element.appendChild(text);
                }
                if (attributes != null) {
                    Enumeration<String> e = attributes.keys();
                    while (e.hasMoreElements()) {
                        String tagName = e.nextElement();
                        element.setAttribute(tagName, (String)attributes.get(tagName));
                    }
                }
            }
        }
        catch (Exception e) {
            String message = "Utilities - Failure create xml node";
            XMLBearbeitungsException be = new XMLBearbeitungsException(message, e);
            log.info((Object)("exception code: " + be.getErrorCode() + " message: " + message));
            throw be;
        }
        return element;
    }

    public static String extractVinShort(String fgnr) throws GKIException {
        try {
            if (fgnr != null) {
                if ((fgnr = fgnr.trim()).length() >= 17) {
                    return fgnr.substring(10, 17);
                }
                if (fgnr.length() <= 7) {
                    return fgnr;
                }
            }
        }
        catch (Exception e) {
            String message = "Utilities - Failure extract vin short";
            XMLBearbeitungsException be = new XMLBearbeitungsException(message, e);
            log.info((Object)("exception code: " + be.getErrorCode() + " message: " + message));
            throw be;
        }
        return "";
    }

    public static String extractVinLongPrefix(String fgnr) throws GKIException {
        try {
            if (fgnr != null && (fgnr = fgnr.trim()).length() >= 17) {
                return fgnr.substring(0, 10);
            }
        }
        catch (Exception e) {
            String message = "Utilities - Failure extract vin long prefix";
            XMLBearbeitungsException be = new XMLBearbeitungsException(message, e);
            log.info((Object)("exception code: " + be.getErrorCode() + " message: " + message));
            throw be;
        }
        return "";
    }

    public static String replaceToken(String s, String currentToken, String newToken) throws GKIException {
        try {
            int iPos = -1;
            while ((iPos = s.indexOf(currentToken, iPos + 1)) >= 0) {
                StringBuffer buff = new StringBuffer();
                String part1 = s.substring(0, iPos);
                String part2 = s.substring(iPos + currentToken.length());
                buff.append(part1);
                buff.append(newToken);
                buff.append(part2);
                s = buff.toString();
            }
        }
        catch (Exception e) {
            throw new SystemException(".replaceToken:Unerwartete Exception:", e);
        }
        return s;
    }

    public static void touchFile(String filename) {
        try {
            boolean b;
            File f = new File(filename);
            if (f.exists() && !(b = f.setLastModified(System.currentTimeMillis()))) {
                log.error((Object)("touchFile:failed(" + filename + ")"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isVersionCompatibleWith(String specVersion, String desiredVersion) {
        if (specVersion != null && specVersion.length() > 0 && desiredVersion != null && desiredVersion.length() > 0) {
            StringTokenizer dtok = new StringTokenizer(desiredVersion, ".", true);
            StringTokenizer stok = new StringTokenizer(specVersion, ".", true);
            while (dtok.hasMoreTokens() || stok.hasMoreTokens()) {
                int dver = dtok.hasMoreTokens() ? Integer.parseInt(dtok.nextToken()) : 0;
                int sver = stok.hasMoreTokens() ? Integer.parseInt(stok.nextToken()) : 0;
                if (sver < dver) {
                    return false;
                }
                if (sver > dver) {
                    return true;
                }
                if (dtok.hasMoreTokens()) {
                    dtok.nextToken();
                }
                if (!stok.hasMoreTokens()) continue;
                stok.nextToken();
            }
        }
        return true;
    }

    public static String convertIfUnicode(String theString) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len);
        int x = 0;
        while (x < len) {
            int aChar;
            if ((aChar = theString.charAt(x++)) == 92) {
                if ((aChar = theString.charAt(x++)) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = theString.charAt(x++);
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    outBuffer.append((char)value);
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                outBuffer.append((char)aChar);
                continue;
            }
            outBuffer.append((char)aChar);
        }
        return outBuffer.toString();
    }

    public static boolean isNullOrEmptyString(String str) {
        return str == null || str.length() == 0;
    }

    public static void waitSeconds(int count) {
        Date testStart = new Date();
        Date testEnde = new Date();
        long diff = 0L;
        while ((diff = (testEnde = new Date()).getTime() - testStart.getTime()) < (long)(count * 1000)) {
        }
    }

    public static void checkValidServicePartnerID(ServicePartnerID servicePartnerID) throws ServicePartnerIDInvalidException {
        if (servicePartnerID != null) {
            if (servicePartnerID.getVertriebspartnerNr() == null || servicePartnerID.getVertriebspartnerNr().length() == 0) {
                throw new ServicePartnerIDInvalidException("vertriebspartnerNr ist nicht gesetzt!");
            }
            if (servicePartnerID.getBetriebsNr() == null || servicePartnerID.getBetriebsNr().length() == 0) {
                throw new ServicePartnerIDInvalidException("betriebsNr ist nicht gesetzt!");
            }
        } else {
            throw new ServicePartnerIDInvalidException("vertriebspartnerNr/betriebsNr sind nicht gesetzt!");
        }
    }

    public static void checkIsoLaenderCode(String isoLaenderCode) throws CountryCodeInvalidException {
        if (isoLaenderCode == null || isoLaenderCode.length() == 0) {
            throw new CountryCodeInvalidException("isoLaenderCode ist nicht gesetzt!");
        }
    }

    public static ArrayList<Object> wrapArray(Object[] array) {
        return new ArrayList<Object>(Arrays.asList(array));
    }

    public static String getAbsoluteFileName(String relativePath, String fileName) {
        if (relativePath.endsWith("/")) {
            return Utilities.getAbsolutePath(relativePath).concat(fileName);
        }
        return Utilities.getAbsolutePath(relativePath).concat("/").concat(fileName);
    }

    public static String getAbsolutePath(String relativePath) {
        URL root = Utilities.class.getResource(relativePath);
        return root != null ? root.getFile() : relativePath;
    }

    public static Date getYesterday() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date setLateNightTime(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(14, 9999);
        return cal.getTime();
    }

    public static String getFormatPattern(Locale locale) {
        DateFormat dateFormat = DateFormat.getDateInstance(3, locale);
        return ((SimpleDateFormat)dateFormat).toPattern();
    }

    public static int getFirstDayOfWeek(Locale locale) {
        Calendar calendar = Calendar.getInstance(locale);
        return calendar.getFirstDayOfWeek();
    }

    public static Vector<Boolean> getSelectionValues(String selectedListAsString) {
        Vector<Boolean> selectionValues = new Vector<Boolean>();
        StringTokenizer stringTokenizer = new StringTokenizer(selectedListAsString, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken();
            if (token.equals("1")) {
                selectionValues.add(Boolean.TRUE);
                continue;
            }
            selectionValues.add(Boolean.FALSE);
        }
        return selectionValues;
    }

    public static String getShortClassName(String className) {
        String shortClassName = className;
        try {
            int idx;
            if (className != null && (idx = className.lastIndexOf(".")) >= 0) {
                shortClassName = className.substring(idx + 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return shortClassName;
    }

    public static String formatInt(int value, Locale locale) {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(locale);
        DecimalFormat dformat = new DecimalFormat("#,###,###,###", dfs);
        return dformat.format(value);
    }

    public static String formatFloat(float value, Locale locale) {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(locale);
        DecimalFormat dformat = new DecimalFormat("#,###,###,###", dfs);
        dformat.setMinimumFractionDigits(2);
        dformat.setMaximumFractionDigits(2);
        return dformat.format(value);
    }

    public static boolean isDateInFuture(Date date) {
        long currentTimeInMillis = System.currentTimeMillis();
        return currentTimeInMillis < date.getTime();
    }

    public static String getLocalName(String nodeName) {
        int last = nodeName.lastIndexOf(":");
        return nodeName.substring(last + 1);
    }

    public static String getAbsolutFilename(String file) {
        String installpath = null;
        try {
            URL url = Utilities.class.getResource("/" + file);
            if (url != null && (installpath = url.getFile()).length() > 0) {
                installpath = installpath.replaceAll("%20", " ");
                return installpath;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        installpath = System.getProperty("sam.test.dir");
        if (installpath == null) {
            // empty if block
        }
        return installpath;
    }

    public static String getDateAsMonthYear(int month, int year, Locale locale) {
        Calendar dDatum = Calendar.getInstance(locale);
        dDatum.set(2, month - 1);
        dDatum.set(1, year);
        return Utilities.getDateAsMonthYear(dDatum.getTime(), locale);
    }

    public static String getDateAsMonthYear(Date date, Locale locale) {
        SimpleDateFormat formatMonatJahr = new SimpleDateFormat("MM'.'yyyy", locale);
        String dateMonthYear = formatMonatJahr.format(date);
        return dateMonthYear;
    }

    public static String formatCombinedCBSRemainingValues(String remainingTime, String remainingDistance, Locale locale) {
        String concatString = "";
        concatString = remainingDistance != null && remainingDistance.length() > 0 ? remainingTime + " / " + remainingDistance : remainingTime;
        return concatString;
    }

    public static boolean checkWildcard(String str) {
        boolean flag = false;
        if (str.indexOf("*") == -1) {
            flag = true;
        } else if (str.indexOf("*") == str.length() - 1 && str.length() > 1) {
            flag = true;
        }
        return flag;
    }

    public static String checkLength(String value, int length) {
        if (value.length() < length && value.indexOf("*") == -1) {
            value = value.concat("*");
        }
        return value;
    }

    public static synchronized String saveLogBinFile(byte[] content, String path, String filePrefix) throws IOException {
        log.trace((Object)"save bin file is calleD");
        OutputStream out = null;
        File f = null;
        try {
            f = Utilities.getBinFile(path, filePrefix);
            out = new BufferedOutputStream(new FileOutputStream(f));
            out.write(content);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (Exception e) {}
            }
        }
        return f.getName();
    }

    private static File getBinFile(String path, String filePrefix) {
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        Date date = new Date();
        int index = 1;
        File file = null;
        while ((file = new File(dir, filePrefix + "_" + dateTimeFormatter.format(date) + "_" + index++ + ".bin")).exists()) {
        }
        return file;
    }

    private static File getLogFile(String path) {
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        Date date = new Date();
        return new File(dir, "log_" + dateFormatter.format(date) + ".log");
    }

    public static synchronized void writeLogFile(String binFileName, List<String> entries, String path) {
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File file = Utilities.getLogFile(path);
        String text = "";
        text = binFileName != null ? "|" + binFileName + "|" + System.getProperty("line.separator") : "| no bin file saved |" + System.getProperty("line.separator");
        if (entries != null && entries.size() > 0) {
            for (int i = 0; i < entries.size(); ++i) {
                text = text + entries.get(i) + System.getProperty("line.separator");
            }
            Utilities.appendFile(file, text);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void appendFile(File logFile, String appendText) {
        PrintStream out = null;
        try {
            out = new PrintStream(new AppendFileStream(logFile));
            out.print(appendText);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Long copyFile(File srcFile, File destFile) throws IOException {
        int bufferSize = 4096;
        boolean clock = false;
        boolean verify = true;
        long millis = 0L;
        CRC32 checksum = null;
        FileInputStream in = null;
        OutputStream out = null;
        try {
            int bytesRead;
            in = new FileInputStream(srcFile);
            out = new FileOutputStream(destFile);
            millis = System.currentTimeMillis();
            if (verify) {
                checksum = new CRC32();
                checksum.reset();
            }
            byte[] buffer = new byte[bufferSize];
            while ((bytesRead = ((InputStream)in).read(buffer)) >= 0) {
                if (verify) {
                    checksum.update(buffer, 0, bytesRead);
                }
                out.write(buffer, 0, bytesRead);
            }
            out.flush();
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (Exception e) {}
            }
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (Exception e) {}
            }
        }
        if (clock) {
            millis = System.currentTimeMillis() - millis;
            log.trace((Object)("Second(s): " + millis / 1000L));
        }
        if (verify) {
            return new Long(checksum != null ? checksum.getValue() : 0L);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean contentsEqual(String path1, String path2, boolean ignoreWhitespace) {
        FileInputStream is1 = null;
        InputStream is2 = null;
        try {
            int c2;
            int c1;
            is1 = new FileInputStream(path1);
            is2 = new FileInputStream(path2);
            if (is1 == is2) {
                boolean bl = true;
                return bl;
            }
            if (is1 == null || is2 == null) {
                boolean bl = false;
                return bl;
            }
            do {
                c1 = ((InputStream)is1).read();
                c2 = is2.read();
                while (ignoreWhitespace && Utilities.isWhitespace(c1)) {
                    c1 = ((InputStream)is1).read();
                }
                while (ignoreWhitespace && Utilities.isWhitespace(c2)) {
                    c2 = is2.read();
                }
                if (c1 != -1 || c2 != -1) continue;
                boolean bl = true;
                return bl;
            } while (c1 == c2);
            return false;
        }
        catch (IOException ex) {
            return false;
        }
        finally {
            if (is1 != null) {
                try {
                    ((InputStream)is1).close();
                }
                catch (Exception e) {}
            }
            if (is2 != null) {
                try {
                    is2.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private static boolean isWhitespace(int c) {
        if (c == -1) {
            return false;
        }
        return Character.isWhitespace((char)c);
    }

    public static File[] getFiles(String specDir) {
        File dir = new File(specDir);
        File[] children = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.isDirectory();
            }
        });
        return children;
    }

    public static boolean isCommentLine(String line) {
        return line == null || line.length() == 0 || line.startsWith(LINE_COMMENT) || line.startsWith("\t") || line.startsWith("\n");
    }
}

