<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl = "http://www.w3.org/1999/XSL/Transform" version = "1.0" >
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>

   <xsl:template match="/">
  		<xsl:apply-templates/>
    </xsl:template>
    
<!-- AKR Bug in schem 01 - element name heisst refSchema -->
<xsl:template match = "*[local-name()='analyseKeyResponse']">

	    <xsl:copy>
	    		<xsl:element name="refSchema" namespace="http://www.bmw.com/score">
				<xsl:attribute name="refSchema">interpretKeyGKI</xsl:attribute>
				<xsl:attribute name="version">00.01.00</xsl:attribute>
		</xsl:element>
			<xsl:apply-templates select="*[local-name()='keyDataAnalysed']"/>
			<xsl:apply-templates select="*[local-name()='error']"/>
		</xsl:copy>
	</xsl:template>
 
<!-- AKR ENDE Behandlung refSchema-->

	<!-- Workaround für lokale SI-Verträge im alten Schema ist nur ContractVolume B, S, R und F erlaubt -->
	<!--  
	<xsl:template match = "*[local-name()='servicePackageList']">
		<xsl:if test="*/*[local-name()='contractVolume' and (text()='B' or text()='S' or text()='R' or text()='F')]">
			<xsl:copy>
					<xsl:apply-templates select = "node()|@*" />
			</xsl:copy>
		</xsl:if>
	</xsl:template>
	<xsl:template match = "*[local-name()='servicePackage']">
		<xsl:choose>
			<xsl:when test="*[local-name()='contractVolume' and (text()='B' or text()='S' or text()='R' or text()='F')]">
				<xsl:copy>
						<xsl:apply-templates select = "node()|@*" />
				</xsl:copy>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	-->
	 
	<xsl:template match="@version"><xsl:attribute name="version">00.01.00</xsl:attribute></xsl:template>
	<xsl:template match="@schemaRef"><xsl:attribute name="schemaRef">interpretKeyGKI</xsl:attribute></xsl:template>

	
	<!--  clear all nodes and attributes generally in interpretKey, analyseKey,...-->
	<xsl:template match = "*//*[local-name()='gearCount']"/>
	<xsl:template match = "*//*[local-name()='engine']"/>
	<xsl:template match = "*//*[local-name()='cylinderCount']"/>
	<xsl:template match = "*//*[local-name()='steering']"/>
	<xsl:template match = "*//*[local-name()='cubicCapacity']"/>
	<xsl:template match = "*//*[local-name()='transmission']"/>
	<xsl:template match = "*//*[local-name()='bodyType']"/>
	<xsl:template match = "*//*[local-name()='writeMode']"/>
	
	<xsl:template match = "*//@countEcuResponding"/>
	<xsl:template match = "*//@countEcuWithErrors"/>
	<xsl:template match = "*//*[local-name()='ecuErrors']"/>
	
	
	
	<!--  insert AKR --> 
	
	<xsl:template match = "*//@genkiVersion"/>
	<xsl:template match = "*//@ksdVersion"/>	
	
	<xsl:template match = "*//@countActiveCCM"/>
	<xsl:template match = "*//*[local-name()='extendedAttributes']"/>
	<xsl:template match = "*//*[local-name()='ecuIdentData']"/>
	<xsl:template match = "*//*[local-name()='dfzKey']"/>
	<xsl:template match = "*//*[local-name()='yellowServiceDistance']"/>
	<xsl:template match = "*//*[local-name()='yellowServiceTime']"/>
	<xsl:template match = "*//*[local-name()='statusMeasure']"/>


    <xsl:template match = "*//*[local-name()='dtcData']">
      <xsl:if test="count(*[local-name()='dtc'])>0">
	    <xsl:copy>
			<xsl:apply-templates select = "node()|@*" />
		</xsl:copy>
      </xsl:if>
    </xsl:template>
    
    <!-- AKR:  iLevel Plant is required in old version -->
       <xsl:template match = "*//*[local-name()='iLevel']">
                    <xsl:if test="boolean(*[local-name()='iLevelPlant'])">
                        	    <xsl:copy>
								<xsl:apply-templates select = "node()|@*" />
								</xsl:copy>
                    </xsl:if>
    </xsl:template>
	
	<!--  clear all nodes and attributes from keyDataAnalysed -->
	<xsl:template match = "*[local-name()='keyDataAnalysed']//*[local-name()='dealerNumber']"/>
	
	<xsl:template match = "*[local-name()='keyDataAnalysed']//*[local-name()='eSeries']"/>
		<xsl:template match = "*[local-name()='keyDataAnalysed']//*[local-name()='writeDate']"/>
	<xsl:template match = "*[local-name()='keyDataAnalysed']//*[local-name()='forecastRemainingTime']"/>
	<xsl:template match = "*[local-name()='keyDataAnalysed']//*[local-name()='forecastRemainingDistance']"/>
	<xsl:template match = "*[local-name()='keyDataAnalysed']//*[local-name()='statusTeleservice']"/>
	<xsl:template match = "*[local-name()='keyDataAnalysed']//*[local-name()='statusTeleserviceCall']"/>
		<xsl:template match = "*[local-name()='keyDataAnalysed']//*[local-name()='cc']//@totalDistance"/>
				<xsl:template match = "*[local-name()='keyDataAnalysed']//*[local-name()='dtc']//@ecuAddress"/>

	<!--xsl:template match = "*[local-name()='cc']//@totalDistance"/-->

		
	

	<!--  clear all nodes and attributes from orderbase (used in interpretKey and updateOrderbase) -->
	<xsl:template match = "*[local-name()='orderbase']//*[local-name()='cylinder']"/>
	
	<xsl:template match = "*[local-name()='orderbase']//*[local-name()='statusTeleservice']"/>
	<xsl:template match = "*[local-name()='orderbase']//*[local-name()='codeCBSYellow']"/>
	<xsl:template match = "*[local-name()='orderbase']//*[local-name()='codeCBSHUAU']"/>
	<xsl:template match = "*[local-name()='orderbase']//*[local-name()='displayUnit']"/>
	<xsl:template match = "*[local-name()='orderbase']//*[local-name()='cbsCount']"/>
	<xsl:template match = "*[local-name()='orderbase']//*[local-name()='cbsVariant']"/>

 
    <xsl:template match = "*[local-name()='orderbase']//*[local-name()='availability']"/>
    <xsl:template match = "*[local-name()='orderbase']//*[local-name()='dueDate']"/>
	<xsl:template match = "*[local-name()='orderbase']//*[local-name()='statusTeleserviceCbsCall']"/>
	<xsl:template match = "*[local-name()='orderbase']//*[local-name()='forecastRemainingTime']"/>
	<xsl:template match = "*[local-name()='orderbase']//*[local-name()='forecastRemainingDistance']"/>
	<xsl:template match = "*[local-name()='orderbase']//*[local-name()='cbsId']"/>
	
	<!-- insert AKR  -->
	<xsl:template match = "*[local-name()='ccMessages']//*[local-name()='totalDistance']"/>
	<xsl:template match = "*[local-name()='orderbase']//*[local-name()='averageDistance']"/>
	<xsl:template match = "*[local-name()='orderbase']//@ecuAddress"/>

	<xsl:template match = "*[local-name()='vehicleKey']">
	    <xsl:copy>
			<xsl:apply-templates select = "node()|@*" />
			<xsl:apply-templates select="*[local-name()='writeDate']" mode="lastRefreshDate"/>
		</xsl:copy>
	</xsl:template>

  <xsl:template match = "*[local-name()='writeDate']" mode="lastRefreshDate">
	
		<xsl:element name="lastRefreshDate" namespace="http://www.bmw.com/score">
			<xsl:value-of select="." />
		</xsl:element>
	
	</xsl:template>


	
	<xsl:template match = "*">
	    <xsl:copy>
			<xsl:apply-templates select = "node()|@*" />
		</xsl:copy>
	</xsl:template>
	<xsl:template match="@*">
		<xsl:copy/>
	</xsl:template>
	
</xsl:stylesheet>