<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl = "http://www.w3.org/1999/XSL/Transform" version = "1.0" >
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>

    <xsl:template match="/">
  		<xsl:apply-templates/>
    </xsl:template>

	<xsl:template match="@version"><xsl:attribute name="version">02.00.00</xsl:attribute></xsl:template>
	<xsl:template match="@schemaRef"><xsl:attribute name="schemaRef">interpretKeyGKI</xsl:attribute></xsl:template>

	<!--  clear all nodes and attributes generally in interpretKey, analyseKey,...-->
	<!-- insert MTT -->
	<xsl:template match = "*[local-name()='servicePackage']">
		<xsl:copy>
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="*[local-name()='contract']"/>
			<xsl:apply-templates select="*[local-name()='contractVolume']"/>
			<xsl:apply-templates select="*[local-name()='origin']"/>
			<xsl:apply-templates select="*[local-name()='duration']"/>
			<xsl:apply-templates select="*[local-name()='distance']"/>
			<xsl:apply-templates select="*[local-name()='startDate']"/>
			<xsl:apply-templates select="*[local-name()='endDate']"/>
			<xsl:apply-templates select="*[local-name()='description']"/>
		</xsl:copy>
	</xsl:template>
	
	<xsl:template match = "*">
	    <xsl:copy>
			<xsl:apply-templates select = "node()|@*" />
		</xsl:copy>
	</xsl:template>
	<xsl:template match="@*">
		<xsl:copy/>
	</xsl:template>
	
</xsl:stylesheet>