<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl = "http://www.w3.org/1999/XSL/Transform" version = "1.0" 
	xmlns:old="http://www.bmw.com/gki" exclude-result-prefixes="old">
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>

    <xsl:template match="/">
  		<xsl:apply-templates/>
    </xsl:template>

	<xsl:template match="@version"><xsl:attribute name="version">03.00.00</xsl:attribute></xsl:template>
	<xsl:template match="@schemaRef"><xsl:attribute name="schemaRef">interpretKeyGKI</xsl:attribute></xsl:template>

	<!--  clear all nodes and attributes generally in interpretKey, analyseKey,...-->


	
	<xsl:template match = "*">
	    <xsl:copy>
			<xsl:apply-templates select = "node()|@*" />
		</xsl:copy>
	</xsl:template>
	<xsl:template match="@*">
		<xsl:copy/>
	</xsl:template>
	
	<!-- replace namespace of elements in old namespace -->
	<xsl:template match="old:*">
		<xsl:element name="{local-name()}" namespace="http://www.bmw.com/score">
			<xsl:apply-templates select="@* | node()"/>
		</xsl:element>
	</xsl:template>
	
	<!-- dfzKey must have only value for this version -->
	<xsl:template match = "*//*[local-name()='dfzKey']">
		<xsl:element name="dfzKey" namespace="http://www.bmw.com/score">
			<xsl:element name="value" namespace="http://www.bmw.com/score">
				<xsl:value-of select="*[local-name()='value']" />
			</xsl:element>
		</xsl:element>
	</xsl:template>
	
</xsl:stylesheet>