# Generated by Django 2.1.11 on 2019-12-18 09:05

import common.utils.django
from django.conf import settings
from django.db import migrations, models
import django.utils.timezone
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ('users', '0024_auto_20191118_1612'),
        ('assets', '0046_auto_20191218_1705'),
        ('applications', '0004_auto_20191218_1705'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('perms', '0009_remoteapppermission_system_users'),
    ]

    operations = [
        migrations.CreateModel(
            name='DatabaseAppPermission',
            fields=[
                ('org_id', models.CharField(blank=True, db_index=True, default='', max_length=36, verbose_name='Organization')),
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=128, verbose_name='Name')),
                ('is_active', models.BooleanField(default=True, verbose_name='Active')),
                ('date_start', models.DateTimeField(db_index=True, default=django.utils.timezone.now, verbose_name='Date start')),
                ('date_expired', models.DateTimeField(db_index=True, default=common.utils.django.date_expired_default, verbose_name='Date expired')),
                ('created_by', models.CharField(blank=True, max_length=128, verbose_name='Created by')),
                ('date_created', models.DateTimeField(auto_now_add=True, verbose_name='Date created')),
                ('comment', models.TextField(blank=True, verbose_name='Comment')),
                ('database_apps', models.ManyToManyField(blank=True, related_name='granted_by_permissions', to='applications.DatabaseApp', verbose_name='DatabaseApp')),
                ('system_users', models.ManyToManyField(related_name='granted_by_database_app_permissions', to='assets.SystemUser', verbose_name='System user')),
                ('user_groups', models.ManyToManyField(blank=True, to='users.UserGroup', verbose_name='User group')),
                ('users', models.ManyToManyField(blank=True, to=settings.AUTH_USER_MODEL, verbose_name='User')),
            ],
            options={
                'verbose_name': 'DatabaseApp permission',
                'ordering': ('name',),
            },
        ),
        migrations.AlterUniqueTogether(
            name='databaseapppermission',
            unique_together={('org_id', 'name')},
        ),
    ]
