# Generated by Django 2.2.13 on 2020-08-07 07:13

import common.utils.django
from django.conf import settings
from django.db import migrations, models
import django.utils.timezone
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ('assets', '0054_auto_20200807_1032'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('applications', '0005_k8sapp'),
        ('users', '0028_auto_20200728_1805'),
        ('perms', '0011_auto_20200721_1739'),
    ]

    operations = [
        migrations.CreateModel(
            name='K8sAppPermission',
            fields=[
                ('org_id', models.CharField(blank=True, db_index=True, default='', max_length=36, verbose_name='Organization')),
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=128, verbose_name='Name')),
                ('is_active', models.BooleanField(default=True, verbose_name='Active')),
                ('date_start', models.DateTimeField(db_index=True, default=django.utils.timezone.now, verbose_name='Date start')),
                ('date_expired', models.DateTimeField(db_index=True, default=common.utils.django.date_expired_default, verbose_name='Date expired')),
                ('created_by', models.CharField(blank=True, max_length=128, verbose_name='Created by')),
                ('date_created', models.DateTimeField(auto_now_add=True, verbose_name='Date created')),
                ('comment', models.TextField(blank=True, verbose_name='Comment')),
                ('k8s_apps', models.ManyToManyField(blank=True, related_name='granted_by_permissions', to='applications.K8sApp', verbose_name='KubernetesApp')),
                ('system_users', models.ManyToManyField(related_name='granted_by_k8s_app_permissions', to='assets.SystemUser', verbose_name='System user')),
                ('user_groups', models.ManyToManyField(blank=True, to='users.UserGroup', verbose_name='User group')),
                ('users', models.ManyToManyField(blank=True, to=settings.AUTH_USER_MODEL, verbose_name='User')),
            ],
            options={
                'verbose_name': 'KubernetesApp permission',
                'ordering': ('name',),
                'unique_together': {('org_id', 'name')},
            },
        ),
    ]
