
/*===========================================================================
  
  This file includes SVRF/TVF Technology under license by Mentor
  Graphics Corporation.  "SVRF/TVF Technology" shall mean Mentor Graphics'
  Standard Verification Rule Format ("SVRF") and Tcl Verification Format
  ("TVF") proprietary syntaxes for expressing process rules. You shall not
  use SVRF/TVF Technology unless you are a Mentor Graphics customer with a
  license to use the applicable Mentor Graphics software. The exact terms
  of your obligations and rights are governed by your respective license.
  You shall not use SVRF/TVF Technology except: (a) for your internal
  business purposes and (b) for use with Mentor Graphics' Calibre(R)
  tools. All SVRF/TVF Technology constitutes or contains trade secrets and
  confidential information of Mentor Graphics or its licensors. You shall
  not make SVRF/TVF Technology available in any form to any person other
  than your employees and on-site contractors, excluding Mentor Graphics
  competitors, whose job performance requires access and who are under
  obligations of confidentiality. 

===========================================================================*/


// This file includes the layer name assignments for the design, global layer 
// derivations and the connectivity sequences for fullchip.oas.

// This file should be included in rule files that read the layout.

LAYER MAP >=0 DATATYPE >=0 999
LAYER MAP >=0 TEXTTYPE >=0 999
LAYER ignore 999

LAYER MAP 1 DATATYPE >=0 1
LAYER OX 1

LAYER MAP 3 DATATYPE >=0 3
LAYER NW 3

LAYER MAP 4 DATATYPE >=0 4
LAYER NPLUS 4

LAYER MAP 5 DATATYPE >=0 5
LAYER PPLUS 5

LAYER MAP 7 DATATYPE >=0 7
LAYER VTH 7

LAYER MAP 8 DATATYPE >=0 8
LAYER TOX 8

LAYER MAP 9 DATATYPE >=0 9
LAYER PO 9

LAYER MAP 10 DATATYPE >=0 10
LAYER CO 10

LAYER MAP 11 DATATYPE >=0 11
LAYER MAP 11 TEXTTYPE >=0 11
LAYER M1 11

LAYER MAP 12 DATATYPE >=0 12
LAYER V1 12

LAYER MAP 13 DATATYPE >=0 13
LAYER MAP 13 TEXTTYPE >=0 13
LAYER M2 13

LAYER MAP 14 DATATYPE >=0 14
LAYER V2 14

LAYER MAP 15 DATATYPE >=0 15
LAYER MAP 15 TEXTTYPE >=0 15
LAYER M3 15

LAYER MAP 16 DATATYPE >=0 16
LAYER V3 16

LAYER MAP 17 DATATYPE >=0 17
LAYER MAP 17 TEXTTYPE >=0 17
LAYER M4 17

LAYER MAP 18 DATATYPE >=0 18
LAYER V4 18

LAYER MAP 19 DATATYPE >=0 19
LAYER MAP 19 TEXTTYPE >=0 19
LAYER M5 19

LAYER MAP 20 DATATYPE >=0 20
LAYER V5 20

LAYER MAP 21 DATATYPE >=0 21
LAYER MAP 21 TEXTTYPE >=0 21
LAYER M6 21

LAYER MAP 22 DATATYPE >=0 22
LAYER V6 22

LAYER MAP 23 DATATYPE >=0 23
LAYER MAP 23 TEXTTYPE >=0 23
LAYER M7 23

LAYER MAP 24 DATATYPE >=0 24
LAYER V7 24

LAYER MAP 25 DATATYPE >=0 25
LAYER MAP 25 TEXTTYPE >=0 25
LAYER M8 25

LAYER MAP 26 DATATYPE >=0 26
LAYER V8 26

LAYER MAP 27 DATATYPE >=0 27
LAYER MAP  27 TEXTTYPE >=0 27
LAYER M9 27

LAYER MAP 28 DATATYPE >=0 28
LAYER V9 28

LAYER MAP 29 DATATYPE >=0 29
LAYER MAP 29 TEXTTYPE >=0 29
LAYER M10 29

LAYER MAP 30 DATATYPE >=0 30
LAYER CAP_ID 30

LAYER MAP 31 DATATYPE >=0 31
LAYER RES_ID 31

LAYOUT USE DATABASE PRECISION YES
RESOLUTION 5

// This statement should be used in all hierarchical runs.

LAYOUT BASE LAYER OX PO CO TOX

TEXT LAYER M1 M2 M3 M4 M5 M6 M7 M8 M9 M10
PORT LAYER TEXT  M1 M2 M3 M4 M5 M6 M7 M8 M9 M10

TEXT PRINT MAXIMUM 1000

/////// DEFINE BOOLEAN LAYERS ///////

bulk = SIZE (EXTENT) BY 0.055
psub = bulk NOT NW

nwresbody = NW INSIDE RES_ID     // nwell resistor seed layer
nwell = NW NOT nwresbody

gate = PO AND OX                 // gate pins
fieldpoly = PO NOT OX
presbody = fieldpoly AND RES_ID  // PO resistors
ipoly = fieldpoly NOT presbody   // interconnect PO

implant = NPLUS OR PPLUS

/////// N layers ///////

ndif = OX AND NPLUS

ngate1 = PO AND ndif
ngate2 = ngate1 NOT INTERACT VTH    
ngate  = ngate2 NOT INTERACT TOX  // MN(NMOS_VTL) seed layer
hvtngate = ngate1 INTERACT VTH    // MN(NMOS_VTH) seed layer
thkoxngate = ngate1 INTERACT TOX  // MN(NMOS_THKOX) seed layer

nsrcdrn = ndif NOT ngate1         // nsd pin layer

ncont = nsrcdrn AND NW

/////// P layers ///////

pdif = OX AND PPLUS 

pgate1 = PO AND pdif
pgate2 = pgate1 NOT INTERACT VTH
pgate  = pgate2 NOT INTERACT TOX  // MP(PMOS_VTL) seed layer
hvtpgate = pgate1 INTERACT VTH    // MP(PMOS_VTH) seed layer
thkoxpgate = pgate1 INTERACT TOX  // MP(PMOS_THKOX) seed layer

psrcdrn = pdif NOT pgate1         // psd pin layer

pcont = psrcdrn AND psub

/////// for caps ///////

capneg = M2 AND CAP_ID              // cap neg pin layer
cappos = M3 AND CAP_ID              // cap pos pin layer
capbody = cappos NOT OUTSIDE capneg // cap seed layer

/////// for resistors ///////

prespin = M1 AND (CO INSIDE RES_ID)  // R(rp) pins

respin  = nsrcdrn INSIDE RES_ID      // R pins


// CONNECT SEQUENCES

#IFNDEF DRC
// For non-DRC applications

CONNECT ipoly   gate
CONNECT M1  ipoly BY CO
CONNECT M1  nsrcdrn BY CO
CONNECT M1  psrcdrn BY CO
CONNECT M1  ncont BY CO
CONNECT M1  pcont BY CO
CONNECT M1  M2 BY V1
CONNECT M2  M3 BY V2
CONNECT M3  M4 BY V3
CONNECT M4  M5 BY V4
CONNECT M5  M6 BY V5
CONNECT M6  M7 BY V6
CONNECT M7  M8 BY V7
CONNECT M8  M9 BY V8
CONNECT M9  M10 BY V9

// device pins 
SCONNECT M3  cappos
SCONNECT M2  capneg
SCONNECT M1  prespin
SCONNECT nsrcdrn respin

// for soft-connection checks
SCONNECT ncont nwell BY CO
SCONNECT pcont psub BY CO

#ENDIF

#IFDEF DRC
// For DRC applications

CONNECT M1  ncont BY CO
CONNECT M1  M2 BY V1
CONNECT M2  M3 BY V2
CONNECT M3  M4 BY V3
SCONNECT ncont nwell BY CO
#ENDIF

